package com.bytedance.ttgame.module.netdiagnose.api.data

data class IpAddressResult(var ipv4Address: String = "") {
    var ipv6Address: String = ""
        set(value) {
            field = processIpv6Address(value)
        }

    private fun processIpv6Address(value: String): String {
        return if (value.contains("%"))
            value.substring(0, value.lastIndexOf("%"))
        else
            value
    }
}