package com.bytedance.ttgame.module.monitor.api;

import com.bytedance.ttgame.framework.module.spi.IModuleApi;

/**
 * MonitorSDK服务
 *
 * @author chenshan
 * @since  2020/7/15.
 */
public interface IMonitorService extends IModuleApi {
    /**
     * 开始进行启动监控
     * 一次应用启动应该只有一次调用
     * startTrace() 必须保证 和 endTrace() 在同一线程，且配对出现
     */
    void startTrace();

    /**
     * 必须保证已调用 startTrace()
     * 同一个module可以在不同的线程
     * 同一个module 的 taskName需要在同一个线程
     * startSpan 和 endSpan 配对使用
     * @param taskName
     */
    void startSpan(String moduleName, String taskName);

    /**
     * 同一个span,必须保证和 startSpan 在同一个线程
     * @param taskName
     */
    void endSpan(String moduleName, String taskName);

    /**
     * 标记结束启动监控，一次启动过程只应该调用一次
     * 和cancelTrace互斥，在cancelTrace之后调用endTrace无效
     * @param customLaunchMode 启动监控的Tag，业务可以自定义扩展
     * @param activityFullClassName 启动结束时的Activity名字
     * @param maxTimeMs  最大时长约束阈值(推荐2000ms)，当 endTrace - startTrace的时长超出阈值时，放弃本次上报
     * @return 返回计算到的 trace 时长
     */
    void endTrace(String customLaunchMode, String activityFullClassName, long maxTimeMs);

    /**
     * 用于撤销本次统计，比如需求是只统计无开屏广告时的appToFeedShow        `                                                   ,
     * 当触发广告展示时，通过调用cancelTask 取消本次统计
     */
    void cancelTrace();

    /**
     * 获取线程数量并上报（不主动上报，也会在启动20分钟后开始周期性监控）
     * @param scene 传入的场景参数，可用作后台过滤
     * @return 返回线程数量：其中高 16 位位总线程数量，低 16 位为 java 线程数量
     */
    void reportThreadCount(String scene);

    /**
     * 开始采集指定场景的电流值（不主动上报，也会定时采集）
     * 注意，满足以下限制才能生效
     * 1. 必须在完成端监控初始化之后（start方法调用且完成读取setting配置，默认功能不开启，需要slardar配置采样命中）
     * 2. 非充电状态
     * 3. app处于前台
     * @param scene
     */
    void startCollectCurrent(String scene);

    /**
     * 结束该场景电流值的采集
     * @param scene
     */
    void stopCollectCurrent(String scene);
}
