package com.bytedance.ttgame.module.loccom.api;

import android.content.Context;

import androidx.annotation.Nullable;

import com.bytedance.ttgame.framework.module.spi.IModuleApi;
import com.bytedance.ttgame.module.loccom.api.callback.LocationCallback;
import com.bytedance.ttgame.sdk.module.location.model.Location;

/**
 * 通用location能力
 * IP定位和缓存取定位信息
 *
 * @author: yangyuming
 * @date: 2020/8/20 {10:22 PM}
 * @email: yangyuming@bytedance.com
 */
public interface ILocationCommonService extends IModuleApi {

    /**
     * 异步通过IP获取定位（不涉及定位权限） - 异步回调
     * @param context 获取IP信息
     * @param callback 回调 数据/ 失败信息
     */
    void getLocationByIp(Context context, LocationCallback<Location> callback);

    /**
     * 从缓存获取定位数据
     * @param context 读缓存需要
     * @return 定位信息
     */
    Location getLocationInfo(Context context);

    /**
     * 同步通过当前网络 IP 地址定位位置
     *
     * @param context 操作上线文
     * @return 需要的 location 信息，null 表示获取失败
     */
    @Nullable
    Location getLocationByIpSync(Context context);
}
