package com.bytedance.ttgame.module.gameinfo.api

import com.google.gson.annotations.SerializedName

const val ERROR_PING_TIMEOUT = 111
const val ERROR_PING_IP_EMPTY = 112
const val ERROR_DEFAULT_MESSAGE = "ping timeout"
const val ERROR_IP_EMPTY_MESSAGE = "ip is empty"
/**
 *
 * @property code Int       错误码
 * @property message String 错误信息
 * @constructor
 */
data class GameInfoError(val code: Int?,
                            val message: String?)

/**
 * @property roleList List<Role>    角色信息列表
 * @constructor
 */
data class RoleList(@SerializedName("role_list") val roleList: List<Role>? = listOf())

/**
 * @property roleId 角色id
 * @property name  角色名字
 * @property level 角色等级
 * @property realServerId 实际所在区服id
 * @property loginTime 毫秒 登陆时间
 */
data class Role(@SerializedName("role_id") val roleId: String = "",
                @SerializedName("name") val name: String = "",
                @SerializedName("level") val level: String = "",
                @SerializedName("server_name") val serverName: String = "",
                @SerializedName("real_server_id") val realServerId: Int = 0,
                @SerializedName("login_time") val loginTime: Long = 0L,
                @SerializedName("avatar_url") val avatarUrl: String = "",
                @SerializedName("job") val job: String = "",
                @SerializedName("extra") val extra: String = "")


/**
 * @property zoneList  区服信息列表
 */
data class ServerList(@SerializedName("zone_list") val zoneList: List<ServerZone> = listOf())

/**
 * @property serverId   区服id
 * @property serverName  区服名称
 * @property serverType  服务器类型
 * @property entry        服务器地址
 * @property gameVersions   游戏版本列表
 * @property opStatus      运维状态
 * @property realServerId   实际的区服id
 * @property isMerged     是否合服
 * @property onlineLoad    是否服务器繁忙
 * @property extraInfo  透传字段
 * @property channels   渠道列表
 * @property platforms  设备平台list
 * @property tags  自定义数据
 * @property openTimestamp 开服时间
 * @property extraKV 自定义参数map
 */
data class ServerInfo(@SerializedName("server_id") val serverId: String = "",
                      @SerializedName("server_name") val serverName: String = "",
                      @SerializedName("server_type") val serverType: Int = 0,
                      @SerializedName("entry") val entry: String = "",
                      @SerializedName("ping_addr") val pingAddr: String = "",
                      @SerializedName("game_versions") val gameVersions: List<String> = listOf(),
                      @SerializedName("op_status") val opStatus: Int = 0,
                      @SerializedName("real_server_id") val realServerId: Int = 0,
                      @SerializedName("is_merged") val isMerged: Boolean = false,
                      @SerializedName("online_load") val onlineLoad: Int = 0,
                      @SerializedName("extra_info") val extraInfo: String = "",
                      @SerializedName("channels") val channels: List<String> = listOf(),
                      @SerializedName("platforms") val platforms: List<String> = listOf(),
                      @SerializedName("tags") val tags: List<ServerTag> = listOf(),
                      @SerializedName("open_timestamp") val openTimestamp: Long = 0L,
                      @SerializedName("extra_kv") val extraKV: Map<String, String> = mapOf(),
                      var time: Int = 0)

data class ServerTag(@SerializedName("value") val value: Int = 0,
                     @SerializedName("name") val name: String = "")

data class ServerZone(@SerializedName("zone_id") val zoneId: Int = 0,
                      @SerializedName("name") val name: String = "",
                      @SerializedName("extra_info") val extraInfo: String = "",
                      @SerializedName("extra_kv") val extraKV: Map<String, String> = mapOf(),
                      @SerializedName("channel_id") val channelId: String = "",
                      @SerializedName("server_list") val serverList: List<ServerInfo> = listOf())

data class ServerRoleList(@SerializedName("zone_list") val serverList: List<ServerZone> = listOf(),
                          @SerializedName("role_list") val roleList: List<Role> = listOf())