package com.bytedance.ttgame.module.gameinfo.api

import com.bytedance.ttgame.framework.module.spi.IModuleApi

interface IGameInfoService : IModuleApi {
    /**
     * 获取角色列表
     *
     * @param callback GetGameInfoCallback
     */
    fun getRoleList(callback: GetGameInfoCallback<RoleList>?)

    /**
     * 获取角色列表
     *
     * @param callback GetGameInfoCallback
     * @param timeout 超时时间,单位s
     */
    fun getRoleList(callback: GetGameInfoCallback<RoleList>?, timeout: Double)

    /**
     * 获取区服列表
     *
     * @param gameVersion 游戏版本号
     * @param callback
     */
    fun getServerList(gameVersion: String?,
                      callback: GetGameInfoCallback<ServerList>?
                      )

    /**
     * 获取区服列表
     *
     * @param gameVersion 游戏版本号
     * @param callback
     * @param timeout 超时时间,单位s
     */
    fun getServerList(gameVersion: String?,
                      callback: GetGameInfoCallback<ServerList>?, timeout: Double)

    /**
     * 获取区服和角色列表
     *
     * @param gameVersion 游戏版本号
     * @param callback
     */
    fun getServerAndRoleList(gameVersion: String?,
                             callback: GetGameInfoCallback<ServerRoleList>?)

    /**
     * 获取区服和角色列表
     *
     * @param gameVersion 游戏版本号
     * @param callback
     * @param timeout 超时时间,单位s
     */
    fun getServerAndRoleList(gameVersion: String?,
                             callback: GetGameInfoCallback<ServerRoleList>?, timeout: Double)

    /**
     * 逐个ping传入的服列表，并逐个返回
     * @param serverList 服信息列表
     * @param callback 回调
     */
    fun pingServerList(serverList: List<ServerInfo>?,
                       callback: IPingServerCallback?)

    /**
     * 逐个ping传入的服列表，并逐个返回
     * @param serverList 服信息列表
     * @param callback 回调
     * @param timeout ping的超时时间 单位s
     */
    fun pingServerList(serverList: List<ServerInfo>?,
                       callback: IPingServerCallback?, timeout: Double)


    /**
     * ping方法
     * @param domain 域名
     * @param count ping的次数
     * @param timeout 超时时间
     */
    fun pingMethod(domain:String, count:Int, timeout:Int):String

    interface GetGameInfoCallback<T> {
        /**
         *
         * @param gameInfo T
         */
        fun onSuccess(gameInfo: T?)

        /**
         *
         * @param error GameInfoError
         */
        fun onFail(error: GameInfoError?)
    }
}

interface IPingServerCallback{
    /**
     * 逐个返回带ping值的serverinfo,及是否返回完成,游戏可以在这里逐步更新ping值,error:错误信息，finish：是否将列表中服信息都ping完
     * @param serverInfo 返回ping完的服信息
     * @param error 错误信息
     * @param finish ping列表是否完成
     */
    fun onUpdatePing(serverInfo: ServerInfo, error: GameInfoError, finish: Boolean)
}