package com.bytedance.ttgame.module.database.api;


import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;

import com.google.gson.annotations.SerializedName;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@NeedEncryption
@Entity(tableName = "user_info")
@Keep
public class UserInfoData implements Serializable, Cloneable {
    @PrimaryKey
    @ColumnInfo(name = "user_id")
    @SerializedName("user_id")
    @NonNull
    public long userId; //uid

    @ColumnInfo(name = "nickname")
    @SerializedName("nickname")
    @NeedEncryption
    public String nickname; //昵称

    @ColumnInfo(name = "avatar_url")
    @SerializedName("avatar_url")
    @NeedEncryption
    public String avatarUrl; //头像url

    @ColumnInfo(name = "token")
    @SerializedName("token")
    @NeedEncryption
    public String token;//有效token

    @ColumnInfo(name = "is_verified")
    @SerializedName("is_verified")
    public boolean isVerified; //是否实名认证

    @ColumnInfo(name = "user_type")
    @SerializedName("user_type")
    public int userType;//用户类型，绑定后为绑定的用户类型

    @ColumnInfo(name = "is_pay")
    @SerializedName("is_pay")
    public boolean isPay; //是否充值过

    @ColumnInfo(name = "is_bound")
    @SerializedName("is_bound")
    public boolean isBound;

    @ColumnInfo(name = "login_time")
    @SerializedName("login_time")
    public long loginTime;//登录时间

    @ColumnInfo(name = "has_pwd")
    @SerializedName("has_pwd")
    public boolean hasPwd; //是否设置密码

    @ColumnInfo(name = "mobile")
    @SerializedName("mobile")
    public String mobile;//手机号

    @ColumnInfo(name = "sdk_open_id")
    @SerializedName("sdk_open_id")
    public String sdkOpenId;//用户唯一标识 gsdk_userId

    @ColumnInfo(name = "tt_user_id")
    @NeedEncryption
    public long ttUserId;//passport user_id

    @ColumnInfo(name = "email")
    @NeedEncryption
    public String email;

    @ColumnInfo(name = "aweme_name")
    @NeedEncryption
    public String awemeName;

    @ColumnInfo(name = "aweme_is_new")
    public boolean isAwemeNew = true;

    @ColumnInfo(name = "toutiao_name")
    @NeedEncryption
    public String toutiaoName;

    @ColumnInfo(name = "toutiao_is_new")
    public boolean isToutiaoNew = true;


    @ColumnInfo(name = "can_bind_visitor")
    public boolean canBindVisitor = true;

    @ColumnInfo(name = "login_way")
    public int loginWay;//login_way代表用户是怎么登进来

    @TypeConverters(ConnectListConverter.class)
    @ColumnInfo(name = "connect_infos")
    @SerializedName("connect_infos")
    @NeedEncryption
    public List<ConnectInfoData> connect_infos;

    @ColumnInfo(name = "aweme_sec_platform_uid")
    @NeedEncryption
    public String awemeSecPlatformUid;//三方加密uid(抖音)

    @SerializedName("client_uuid")
    @ColumnInfo(name = "uuid")
    @NeedEncryption
    public String uuid; // 仅游客使用, 游客对应的uuid

    @SerializedName("multi_bind_status")
    @ColumnInfo(name = "multi_bind_status")
    public boolean multiBindStatus;//多绑定状态，true则为多绑，false则为单绑

    @SerializedName("conflict_user_id")
    @ColumnInfo(name = "conflict_user_id")
    public long conflictUserId;//多绑定情况下，返回-1014或-1020时冲突的三方userId

    @ColumnInfo(name = "is_sc_login")
    public int isScLogin;   // 是否是引继码登录 0:不是引继码登录 1:是引继码登录

    @SerializedName("account_code")
    @ColumnInfo(name = "account_code")
    public String accountCode;  // 账号码

    @SerializedName("encrypted")
    @EncryptionMark
    @ColumnInfo(name = "encrypted")
    public boolean encrypted = false;

    @SerializedName("huoshan_name")
    @ColumnInfo(name = "huoshan_name")
    @NeedEncryption
    public String huoshanName;

    @Override
    public String toString() {
        return "UserInfoData{" +
                "userId=" + userId +
                ", nickname='" + nickname + '\'' +
                ", avatarUrl='" + avatarUrl + '\'' +
                ", token='" + token + '\'' +
                ", isVerified=" + isVerified +
                ", userType=" + userType +
                ", isPay=" + isPay +
                ", isBound=" + isBound +
                ", loginTime=" + loginTime +
                ", userUniqueId='" + sdkOpenId + '\'' +
                ", ttUserId=" + ttUserId +
                ", loginTime=" + sdkOpenId +
                ", email=" + email +
                ", awemeName=" + awemeName +
                ", toutiaoName=" + toutiaoName +
                ", isAwemeNew=" + isAwemeNew +
                ", isToutiaoNew=" + isToutiaoNew +
                ", canBindVisitor=" + canBindVisitor +
                ", login_way=" + loginWay +
                ", connect_infos=" + connect_infos +
                ", awemeSecPlatformUid=" + awemeSecPlatformUid +
                ", uuid='" + uuid + '\'' +
                ", multiBindStatus =" + multiBindStatus +
                ", conflictUserId =" + conflictUserId +
                ", isScLogin =" + isScLogin +
                ", encrypted =" + encrypted +
                ", huoshanName =" + huoshanName +
                '}';
    }

    // 深拷贝
    @NonNull
    @Override
    public UserInfoData clone() throws CloneNotSupportedException {
        UserInfoData newObject = (UserInfoData) super.clone();
        ArrayList<ConnectInfoData> connectInfoData = new ArrayList<>();
        if (connect_infos != null) {
            for (ConnectInfoData connectInfo : connect_infos) {
                connectInfoData.add(connectInfo.clone());
            }
        } else {
            connectInfoData = null;
        }

        newObject.connect_infos = connectInfoData;
        return newObject;
    }
}


