package com.bytedance.ttgame.module.database.api;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import java.util.List;

@Dao
public interface UserInfoDao {

    @Delete
    int deleteAccount(UserInfoData userInfoData);

    @Encryption
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertUserInfo(UserInfoData userInfo);

    @Decryption
    @Query("select * from user_info order by login_time desc")
    LiveData<List<UserInfoData>> getHistoryAccount();

    @Decryption
    @Query("select * from user_info order by login_time desc")
    List<UserInfoData> getHistoryAccountByThread();
}
