package com.bytedance.ttgame.module.database.api;


import androidx.room.Database;
import androidx.room.RoomDatabase;

import com.bytedance.ttgame.module.database.api.FusionUserInfoDao;
import com.bytedance.ttgame.module.database.api.FusionUserInfoData;
import com.bytedance.ttgame.module.database.api.RequestCloudDao;
import com.bytedance.ttgame.module.database.api.RequestCloudData;
import com.bytedance.ttgame.module.database.api.UserInfoDao;
import com.bytedance.ttgame.module.database.api.UserInfoData;


@Database(entities = {RequestCloudData.class, UserInfoData.class, FusionUserInfoData.class}, version = 18, exportSchema = false)
public abstract class SdkDatabase extends RoomDatabase {

    public abstract RequestCloudDao requestCloudDao();

    public abstract UserInfoDao loadUserInfoDao();

    public abstract FusionUserInfoDao loadFusionUserInfoDao();

}
