package com.bytedance.ttgame.module.database.api;

import androidx.annotation.Keep;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;

import com.google.gson.annotations.SerializedName;

import java.util.List;

@Keep
@Entity(tableName = "request_cloud")
public class RequestCloudData {
    @PrimaryKey
    public int id;

    @SerializedName("logo_url")
    @ColumnInfo(name = "logo_url")
    public String logoUrl; //logo地址

    // 这两个key不同, 对外使用protocol_url暴露
    @SerializedName("protocol_url")
    @ColumnInfo(name = "protocol")
    public String protocolUrl; //用户协议地址

    @SerializedName("policy_url")
    @ColumnInfo(name = "policy_url")
    public String policyUrl; //隐私政策地址

    @ColumnInfo(name = "protocol_check")
    @SerializedName("protocol_check")
    public boolean protocolCheck;//是否勾选用户协议

    @ColumnInfo(name = "identity_type")
    @SerializedName("identity_type")
    public int identityType;//用户实名认证的等级 1=low，2=mid，3=high

    @ColumnInfo(name = "little_helper")
    @SerializedName("little_helper") //true false 是否显示悬浮窗
    public String little_helper;

    @ColumnInfo(name = "display_visitor")
    @SerializedName("display_visitor")
    public boolean display_visitor = true;

    @TypeConverters(ListConverter.class)
    @ColumnInfo(name = "hide_login_way")
    @SerializedName("hide_login_way")
    public List<Integer> hide_login_way;

    @TypeConverters(ListConverter.class)
    @ColumnInfo(name = "login_list")
    @SerializedName("login_list")
    public List<Integer> loginList;


    @ColumnInfo(name = "one_key_conf")
    @SerializedName("one_key_conf")
    public String oneKeyConf;

    @ColumnInfo(name = "unlimited_visitor_status")
    @SerializedName("unlimited_visitor_status")
    public boolean unlimited_visitor_status = false;

    @ColumnInfo(name = "multi_bind_status")
    @SerializedName("multi_bind_status")
    public boolean multi_bind_status = false;

    @TypeConverters(ListConverter.class)
    @ColumnInfo(name = "to_resolve_domains")
    @SerializedName("to_resolve_domains")
    public List<String> to_resolve_domains;//要解析的域名列表

    @ColumnInfo(name = "game_net_quality_report")
    @SerializedName("game_net_quality_report")
    public boolean game_net_quality_report = false;//是否上报游戏网络状况

    @ColumnInfo(name = "zb_protocol_url")
    @SerializedName("zb_protocol_url")
    public String zbProtocolUrl;//直播

    @ColumnInfo(name = "pass_emulator")
    @SerializedName("pass_emulator")
    public boolean pass_emulator = true; //是否不限制模拟器游客登录

    @ColumnInfo(name = "is_can_unbind")
    @SerializedName("is_can_unbind")
    public boolean isCanUnbind = true;//是否可以解绑

    @ColumnInfo(name = "bind_limit")
    @SerializedName("bind_limit")
    public int bindLimit;//绑定上限数量

    @ColumnInfo(name="gate_type")
    @SerializedName("gate_type")
    public int gateType; // age gate 弹窗类型

    @ColumnInfo(name="age_limit")
    @SerializedName("age_limit")
    public int ageLimit; // age gate 年龄限制

    @ColumnInfo(name = "display_visitor_conf")
    @SerializedName("display_visitor_conf")
    public boolean display_visitor_conf = true;//云控服务端控制是否显示游客入口

    @ColumnInfo(name = "gate_cd")
    @SerializedName("gate_cd")
    public int gateCD; // age gate CD时间, 单位: 秒

    @ColumnInfo(name = "pass_emulator_payment")
    @SerializedName("pass_emulator_payment")
    public boolean pass_emulator_payment = true;  //支付创建订单是否开启模拟器校验

    @ColumnInfo(name = "skin")
    @SerializedName("skin")
    public String skin; //换肤

    @Override
    public String toString() {
        return "RequestCloudData{" +
                "id=" + id +
                ", logoUrl='" + logoUrl + '\'' +
                ", protocolUrl='" + protocolUrl + '\'' +
                ", policyUrl='" + policyUrl + '\'' +
                ", protocolCheck=" + protocolCheck +
                ", identityType=" + identityType +
                ", little_helper='" + little_helper + '\'' +
                ", display_visitor=" + display_visitor +
                ", hide_login_way=" + hide_login_way +
                ", loginList=" + loginList +
                ", oneKeyConf='" + oneKeyConf + '\'' +
                ", unlimited_visitor_status=" + unlimited_visitor_status +
                ", multi_bind_status=" + multi_bind_status +
                ", to_resolve_domains=" + to_resolve_domains +
                ", game_net_quality_report=" + game_net_quality_report +
                ", zbProtocolUrl='" + zbProtocolUrl + '\'' +
                ", pass_emulator=" + pass_emulator +
                ", display_visitor_conf=" + display_visitor_conf +
                ", isCanUnbind=" + isCanUnbind +
                ", bindLimit=" + bindLimit +
                ", gateType=" + gateType +
                ", ageLimit=" + ageLimit +
                ", gateCD=" + gateCD +
                ", pass_emulator_payment=" + pass_emulator_payment +
                ", skin=" + skin +
                '}';
    }
}
