package com.bytedance.ttgame.module.database.api;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;


@Dao
public interface RequestCloudDao {
    @Query("select * from request_cloud order by id desc limit 0,1")
    LiveData<RequestCloudData> getLast();

    @Query("select * from request_cloud order by id desc limit 0,1")
    RequestCloudData getLastWithThread();

    /**
     * 返回livedata就在主线程
     * 否则必须在子线程，不然就会报错
     *
     * @param requestCloudData
     * @return
     */
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(RequestCloudData requestCloudData);

}
