package com.bytedance.ttgame.module.database.api;

import android.text.TextUtils;

import androidx.room.TypeConverter;

import com.bytedance.ttgame.sdk.module.utils.NumberUtils;

import java.util.ArrayList;
import java.util.List;

import timber.log.Timber;

public class ListConverter {

    @TypeConverter
    public static List<Integer> stringToIntegerList(String data) {
        if (TextUtils.isEmpty(data)) {
            return new ArrayList<Integer>();
        }
        List<Integer> list = new ArrayList<>();
        String[] strings = data.split(",");
        for (int i = 0; i < strings.length; i++) {
            try {
                list.add(NumberUtils.getInteger(strings[i], -1));
            } catch (Exception e) {
                Timber.tag("gsdk_converter").d(e);
            }
        }
        return list;
    }

    @TypeConverter
    public static String integerListToString(List<Integer> integerList) {
        if (integerList == null || integerList.size() < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < integerList.size(); i++) {
            if (i == integerList.size() - 1) {
                sb.append(integerList.get(i));
            } else {
                sb.append(integerList.get(i)).append(",");
            }
        }
        return sb.toString();
    }

    @TypeConverter
    public static List<String> stringToStringList(String data) {
        if (TextUtils.isEmpty(data)) {
            return new ArrayList<String>();
        }
        List<String> list = new ArrayList<>();
        String[] strings = data.split(",");
        for (int i = 0; i < strings.length; i++) {
            try {
                list.add(strings[i]);
            } catch (Exception e) {
                Timber.tag("gsdk_converter").d(e);
            }
        }
        return list;
    }

    @TypeConverter
    public static String stringListToString(List<String> data) {
        if (data == null || data.size() < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.size(); i++) {
            if (i == data.size() - 1) {
                sb.append(data.get(i));
            } else {
                sb.append(data.get(i)).append(",");
            }
        }
        return sb.toString();
    }


}
