package com.bytedance.ttgame.module.database.api;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.PrimaryKey;

import com.google.gson.annotations.SerializedName;

@NeedEncryption
@Keep
@Entity(tableName = "fusion_userinfo")
public class FusionUserInfoData implements Cloneable {
    @NonNull
    @PrimaryKey
    @SerializedName("channel_userId")
    @ColumnInfo(name = "channel_userId")
    public String channelUserId;                 //自研userid

    @ColumnInfo(name = "sdkOpenId")
    @SerializedName("sdkOpenId")
    public String sdkOpenId;

    @NeedEncryption
    @ColumnInfo(name = "accessToken")
    @SerializedName("accessToken")
    public String accessToken;

    @SerializedName("create_time")
    @ColumnInfo(name = "create_time")
    public String createTime;

    @SerializedName("encrypted")
    @EncryptionMark
    @ColumnInfo(name = "encrypted")
    public boolean encrypted = false;

    @Override
    public String toString() {
        return "FusionUserInfoData{" +
                "channelUserId='" + channelUserId + '\'' +
                ", sdkOpenId='" + sdkOpenId + '\'' +
                ", accessToken='" + accessToken + '\'' +
                ", createTime='" + createTime + '\'' +
                ", encrypted='" + encrypted + '\'' +
                '}';
    }

    @NonNull
    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
