package com.bytedance.ttgame.module.database.api;


import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import java.util.List;

@Dao
public interface FusionUserInfoDao {
    @Decryption
    @Query("select * from fusion_userinfo WHERE channel_userId = :userId")
    List<FusionUserInfoData> getFusionUserInfo(String userId);

    @Encryption
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(FusionUserInfoData fusionUserInfoData);
}
