package com.bytedance.ttgame.module.database.api;

import android.text.TextUtils;

import androidx.room.TypeConverter;

import com.bytedance.ttgame.sdk.module.utils.AesCbcUtils;
import com.google.gson.Gson;

import java.util.ArrayList;
import java.util.List;

import timber.log.Timber;

public class ConnectListConverter {

    @TypeConverter
    public static List<ConnectInfoData> stringToconnectInfoDataList(String data) {
        if (TextUtils.isEmpty(data)) {
            return new ArrayList<ConnectInfoData>();
        }
        List<ConnectInfoData> list = new ArrayList<>();
        String[] strings = data.split(";");
        boolean needDecrypt = false;
        if (strings.length > 0 && strings[0].equals("encrypted")) {
            needDecrypt = true;
        }
        for (int i = 0; i < strings.length; i++) {
            try {
                if (needDecrypt && i == 0) {
                    continue;
                }
                String str = needDecrypt ? AesCbcUtils.decrypt(strings[i]) : strings[i];
                list.add(new Gson().fromJson(str, ConnectInfoData.class));
            } catch (Exception e) {
                Timber.tag("gsdk_converter").d(e);
            }
        }

        return list;
    }

    @TypeConverter
    public static String connectInfoDataListToString(List<ConnectInfoData> connectInfoDataList) {
        if (connectInfoDataList == null || connectInfoDataList.size() < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("encrypted;");
        try {
            for (int i = 0; i < connectInfoDataList.size(); i++) {
                if (i == connectInfoDataList.size() - 1) {
                    sb.append(AesCbcUtils.encrypt(new Gson().toJson(connectInfoDataList.get(i))));
                } else {
                    sb.append(AesCbcUtils.encrypt(new Gson().toJson(connectInfoDataList.get(i)))).append(";");
                }
            }
        } catch (Exception e) {
            Timber.tag("gsdk_converter").d(e);
        }
        return sb.toString();
    }
}
