package com.bytedance.ttgame.module.database.api;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;

import com.google.gson.annotations.SerializedName;

import java.io.Serializable;

@Keep
public class ConnectInfoData implements Serializable, Cloneable{

    @SerializedName("puid")
    public long puid;

    @SerializedName("user_type")
    public int user_type;

    @SerializedName("nickname")
    public String nickname;

    @SerializedName("avatar_url")
    public String avatar_url;

    @Override
    public String toString() {
        return "ConnectInfoData {" +
                "puid =" + puid +
                ", user_type ='" + user_type + '\'' +
                ", nickname ='" + nickname + '\'' +
                ", avatar_url =" + avatar_url +
                '}';
    }

    @NonNull
    @Override
    public ConnectInfoData clone() throws CloneNotSupportedException {
        return (ConnectInfoData) super.clone();
    }
}
