package com.bytedance.ttgame.module.crash.api

import android.content.Context

import com.bytedance.ttgame.framework.module.spi.IModuleApi

interface ICrashService : IModuleApi {

    /**
     * crash的时候添加一些自定义的参数 K  V  结构
     * @param extraParams MutableMap<String, String>
     */
    fun addCustomParams(extraParams: MutableMap<String, String>)

    /**
     * 添加标签用于过滤显示
     *
     * @param tagMap 标签的map
     */
    fun addTags(tagMap: MutableMap<String, String>)

    /**
     * 自定义上报
     *
     * @param reason     unity收集到的reason
     * @param name       unity收集到的name
     * @param stackTrace unity收集到的stackTrace
     */
    fun reportCrash(reason: String?, name: String?, stackTrace: String?)


    /**
     * 可以添加自定义参数的上报方式
     *
     * @param reason     unity收集到的reason
     * @param name       unity收集到的name
     * @param stackTrace unity收集到的stackTrace
     * @param filters 过滤条件
     * @param customParams 额外参数
     */
    fun reportCrash(name: String?, reason: String?, stacktrace: String?, filters: Map<String, String>?, customParams: Map<String, String>?)

    /**
     * 添加崩溃时，回调写入游戏脚本堆栈的回调
     *
     * @param callback 崩溃时调用的回调
     */
    fun setScriptStackCallback(callback: IScriptCallback)

    /**
     * 回调接口
     */
    interface IScriptCallback {
        fun getCrashName(): String?
        fun getCrashReason(): String?
        fun getCrashStack(): String?
    }

    /**
     * 设置场景值 - 内部接口
     */
    fun addSceneTag(scene: String)
}
