package com.bytedance.ttgame.module.cdkey.api

import com.google.gson.annotations.SerializedName

/**
 *
 * @property code Int       错误码
 * @property message String 错误信息
 * @constructor
 */
data class CDkeyExchangeResult(@SerializedName("code") val code: Int,
                               @SerializedName("message") val message: String)

/**
 * @property cdkey 礼包兑换码
 * @property role_id 角色id
 * @property server_id 玩家大区id
 */
data class CDKeyInfo(val cdkey: String?,
                     val role_id: String?,
                     val server_id: String? = "")

/**
 * 领奖用户信息
 *
 * @param fromH5 是否从活动链接进入
 * @param activityId 活动ID，从H5跳转链接获取
 * @param process 流程ID，从H5跳转链接获取
 * @param serverId 用户当前所在服务器
 * @param roleID 用户当前所用角色
 * @param fromSource 用户渠道
 */
data class GMUserInfo(val activityId: String?,
                      val processId: String?,
                      val fromH5: Boolean? = false){

    var serverId: String? = ""
    var roleID: String? = ""
    var fromSource: String? = ""
}

class GMGiftExchangeResult {
    var code: Int = 0
    var data: DataBean? = null
    var message: String? = null

    inner class DataBean {
        var process: ProcessBean? = null
        var rewards: RewardsBean? = null

        inner class ProcessBean {
            var process_id: String? = null
            var isActive: Boolean = false
            var progress: ProgressBean? = null
            var code: Int = 0
            var msg: String? = null

            inner class ProgressBean {
                var current: Int = 0
                var target: Int = 0
            }
        }

        inner class RewardsBean {
            var items: List<ItemsBean>? = null

            inner class ItemsBean {
                var id: String? = null
                var num: Int = 0
                var type: String? = null
            }
        }
    }
}


