package com.bytedance.ttgame.module.cdkey.api

import com.bytedance.ttgame.framework.module.spi.IModuleApi

interface ICDKeyService : IModuleApi {
    /**
     * 礼包码兑换
     *
     * @param cdKeyInfo 礼包码相关参数
     * @param callback GetGameInfoCallback
     */
    fun cdkeyExchange(cdKeyInfo: CDKeyInfo,
                      callback: CDKeyExchangeCallback?)

    /**
     * 礼包链接兑换
     * @param param 礼包链接领取相关参数
     * @param callback 领取结果回调
     */
    fun gmGiftExchange(param: GMUserInfo, callback: ExchangeCallback?)


    interface CDKeyExchangeCallback {
        /**
         *
         * @param cdkey T
         */
        fun onSuccess(cdkey: CDkeyExchangeResult)

        /**
         *
         * @param error GameInfoError
         */
        fun onFail(error: CDkeyExchangeResult)
    }

    interface ExchangeCallback {
        fun onSuccess(data:GMGiftExchangeResult.DataBean?)
        fun onFailed(code:Int,errorMsg:String)
    }
}