package com.bytedance.ttgame.module.abtest.api;

import com.bytedance.ttgame.framework.module.spi.IModuleApi;

/**
 * ABTest实验
 *
 * @author wangzhongshan
 * @sine 2019-06-14.
 */
public interface IABTestService extends IModuleApi {

    String TAG = "gsdk_abtest_service";

    /**
     * 注册实验, 所有的实验都必须先注册，然后才能取值使用。
     *
     * @param key 实验key，必须与libra平台的"配置参数"名字保持一致
     * @param desc 实验的说明
     * @param ower 实验的负责人
     * @param defaultValue 实验的默认值，可序列化的值
     */
    void registerExperiment(String key, String desc, String ower, String defaultValue);


    /**
     * 注册实验, 所有的实验都必须先注册，然后才能取值使用。
     *
     * @param key 实验key，必须与libra平台的"配置参数"名字保持一致
     * @param desc 实验的说明
     * @param ower 实验的负责人
     * @param defaultValue 实验的默认值，可序列化的值
     * @param isBindUser 是否对账号信息敏感，以uid维度的实验建议填true，在账号频繁切换的情况，曝光数据更加准确，否则为false
     */
    void registerExperiment(String key, String desc, String ower, String defaultValue, boolean isBindUser);

    /**
     * 注册Setting状态更新回调
     *
     * @param listener 回调
     */
    void registerListener(ABSettingUpdateListener listener);
    /**
     * 实验取值。
     * @param key 实验key值，必须与libra平台的"配置参数"名字保持一致。
     * @return
     */
    String getExperimentValue(String key);

}
