package com.bytedance.ttgame.main.module.log.api

import com.bytedance.ttgame.framework.module.spi.IModuleApi

/**
 * 暴露给CP使用的主动上传log的服务.
 */
interface ILogService : IModuleApi {
    /**
     * 写log.
     *
     * @param content: log content
     *
     * @return Error Code: 0: 成功；1: Log框架初始化失败;
     */
    fun log(level: LogLevel, content: String): Int

    /**
     * 支持的log level.
     */
    enum class LogLevel {
        Warn, Error, Exception, Assert, ProcessInfo
    }
}
