package com.bytedance.ttgame.main.internal.settings;

import androidx.annotation.Nullable;

import com.bytedance.ttgame.framework.module.spi.IModuleApi;
import com.bytedance.ttgame.framework.module.spi.annotation.InternalApi;

import org.json.JSONObject;

import java.util.Map;

@InternalApi
public interface IGsdkSettingsService extends IModuleApi {

     interface SettingsUpdateCallback {
          void onSettingsUpdate(@Nullable JSONObject appSettings);
     }

     /**
      * 初始化Settings(SDK维度)
      */
     IGsdkSettingsService initSDKSettings(Map<String, Object> parmas);

     /**
      * 初始化Settings(APP维度)
      */
     IGsdkSettingsService initAPPSettings(Map<String, Object> parmas);

     /**
      * 发起请求，获取settings配置(SDK维度)
      *
      * 若从本地获取，可不传callback，延时调用 getLocalSettings()获取
      */
     IGsdkSettingsService requestSDKSettings(SettingsUpdateCallback callback);

     /**
      * 发起请求，获取settings配置(APP维度)
      *
      * 若从本地获取，可不传callback，延时调用 getLocalSettings()获取
      */
     IGsdkSettingsService requestAPPSettings(SettingsUpdateCallback callback);

     /**
      * 本地获取settings配置(APP维度)
      *
      * 首次需要先调用 requestSettings()，否则本地没有数据
      */
     JSONObject getAPPLocalSettings();

     /**
      * 本地获取settings配置(SDK维度)
      *
      * 首次需要先调用 requestSettings()，否则本地没有数据
      */
     JSONObject getSDKLocalSettings();
}
