package com.bytedance.ttgame.main.internal.sdkmonitor;


import android.content.Context;

import com.bytedance.ttgame.core.SdkConfig;
import com.bytedance.ttgame.framework.module.spi.IModuleApi;
import com.bytedance.ttgame.framework.module.spi.annotation.InternalApi;


import org.json.JSONObject;

import java.util.Map;

/**
 * 封装、收敛原先的SdkMonitorManager提供的接口，并提供一个获取IModuleLogger实例的接口
 */
@InternalApi
public interface ISdkMonitorLogService extends IModuleApi {

    interface DataProvider {
        String provideSessionId();
    }

    IModuleLogger newModuleLogger(String moduleFilter);

    void setModuleLoggerDebug(Boolean debug);

    void initMonitor(Context context, String did, SdkConfig config, Map<String, String> ext, DataProvider dataProvider);

    /**
     　* describe 此接口用于计算某一种service Name的某一种status的占比以及相关的duration的均值,自动化出报表
     　*
     　* @param serviceName 用于标识报表的维度信息,服务端可以控制其采样率
     　* @param status      某种service下的状态码,用于自定义,目前支持0-100
     　* @param duration    某一种service Name下的所有要出报表的duration值,里边的数据value必须为int float类型
     　* @param logExtr     其它用户需要上传的信息,可以后台查询
     　*/
    void monitorStatusAndDuration(String serviceName, int status, JSONObject duration, JSONObject logExtr);

    /**
     * describe 此接口用来上传用户的一些查询信息,此接口不能自动生成报表,用户可以到后台进行hive查询
     * @param logType 用户自定义log_type
     * @param logExtr 用户自定义上传的数据
     */
    void monitorCommonLog(String logType, JSONObject logExtr);

    /**
     * describe  此接口可以自动化出报表
     * @param serviceName 事件名
     * @param category    可枚举Key-Value
     * @param metric      不可枚举Key-Value
     * @param logExtr     其它用户想要上传的信息字段,可以hive查询,不参与报表的输出
     */
    void monitorEvent(String serviceName, JSONObject category, JSONObject metric, JSONObject logExtr);

    Boolean getLogTypeSwitch(String logType);


    /**
     * 网络错误监控
     *
     * @param duration  网络用时,请求网络的用时
     * @param sendTime  发起网络请求的时间
     * @param sendUrl   发起请求的uri
     * @param sendIp    网络请求时解析的ip地址
     * @param traceCode 服务端返回的log_id,没有的话可以传空
     * @param status    网络请求的状态,比如自定义的一些网络状态,以及纯网络状态,如200,206,304,404,503等等,根据网络的异常可以自定义status
     * @param extJson   可以添加的而外字段
     */
    void monitorApiError(long duration, long sendTime, String sendUrl, String sendIp,
                        String traceCode, int status, JSONObject extJson);

    /**
     * 全量网络监控
     *
     * @param sendDuration 网络用时,请求网络的用时
     * @param sendTime     发起网络请求的时间
     * @param sendUrl      发起请求的uri
     * @param sendIp       网络请求时解析的ip地址
     * @param traceCode    服务端返回的log_id,没有的话可以传空
     * @param status       网络请求的状态,比如自定义的一些网络状态,以及纯网络状态,如200,206,304,404,503等等,根据网络的异常可以自定义status
     * @param extJson      可以添加的而外字段
     */
    void monitorSLA(long sendDuration, long sendTime, String sendUrl,
                   String sendIp, String traceCode, int status, JSONObject extJson);
}
