package com.bytedance.ttgame.main.internal.sdkmonitor;

import java.util.Map;

/**
 * 封装、收敛原先的ModuleLogger提供的能力
 */
public interface IModuleLogger {
    enum LogLevel {
        DEBUG, INFO, WARN, ERROR
    }

    void d(String event, String msg);

    void i(String event, String msg);

    void w(String event, String msg);

    void w(String event, String msg, Throwable e);

    void e(String event, String msg);

    void e(String event, String msg, Throwable e);

    /**
     * @param service 事件名称
     * @param status 可枚举状态(属于 categoryMap 可枚举，例如查看成功的有多少个，失败有多少个)
     */
    void monitorEvent(String service,
                      Object status);

    /**
     * @param service 事件名称
     * @param status 可枚举状态(属于 categoryMap 可枚举，例如查看成功的有多少个，失败有多少个)
     * @param errorCode 同 status
     * @param duration 可枚举状态(属于 metricMap 可枚举，例如统计耗时)
     */
    void monitorEvent(String service,
                      Object status,
                      Object errorCode,
                      long duration,
                      Map<String, Object> categoryMap,
                      Map<String, Object> metricMap,
                      Map<String, Object> extraMap);
}
