package com.bytedance.ttgame.main.internal.net;

import com.bytedance.ttgame.framework.module.spi.IModuleApi;
import com.bytedance.ttgame.framework.module.spi.annotation.InternalApi;

import java.util.Map;


@InternalApi
public interface TTHttpApi extends IModuleApi {

    class TTHttpBody {
        String type;
        byte[] data;

        public TTHttpBody(String type, byte[] data) {
            this.type = type;
            this.data = data;
        }
    }

    String get(IRetrofit retrofit,
               boolean addCommonPara,
               String relativePath,
               Map<String, String> queryMap,
               Map<String, String> headerMap,
               Object extraInfo) throws Exception;

    String doPost(IRetrofit retrofit,
                  String url,
                  Map<String, String> headerMap,
                  Map<String, String> map) throws Exception;

    String doPost(IRetrofit retrofit,
                  String url,
                  Map<String, String> headerMap,
                  TTHttpBody body) throws Exception;

    String doPost(IRetrofit retrofit,
                  String url,
                  Map<String, String> headerMap,
                  TTHttpBody body,
                  boolean addCommonParas) throws Exception;
}
