package com.bytedance.ttgame.main.internal.net;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.bytedance.ttgame.framework.module.util.Objects;


// A generic class that contains data and status about loading this data.
public class Resource<T> {
    @NonNull
    public final Status status;

    @Nullable
    public final T data;

    @Nullable
    public final String message;

    @Nullable
    public final String logId;

    @Override
    public String toString() {
        return "Resource{" +
                "status=" + status +
                ", data=" + data +
                ", message='" + message + '\'' +
                ", logId=" + logId +
                '}';
    }

    private Resource(@NonNull Status status, @Nullable T data,
                     @Nullable String message, @Nullable String logId) {
        this.status = status;
        this.data = data;
        this.message = message;
        this.logId = logId;
    }

    public static <T> Resource<T> success(@NonNull T data) {
        return new Resource<>(Status.SUCCESS, data, null, null);
    }

    public static <T> Resource<T> success(@NonNull T data, @Nullable String logId) {
        return new Resource<>(Status.SUCCESS, data, null, logId);
    }

    public static <T> Resource<T> error(String msg, @Nullable T data) {
        return new Resource<>(Status.ERROR, data, msg, null);
    }

    public static <T> Resource<T> error(String msg, @Nullable T data, @Nullable String logId) {
        return new Resource<>(Status.ERROR, data, msg, logId);
    }

    public static <T> Resource<T> loading(@Nullable T data) {
        return new Resource<>(Status.LOADING, data, null, null);
    }

    public enum Status {SUCCESS, ERROR, LOADING}

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Resource<?> resource = (Resource<?>) o;
        return status == resource.status &&
                Objects.equals(data, resource.data) &&
                Objects.equals(message, resource.message) &&
                Objects.equals(logId, resource.logId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(status, data, message, logId);
    }
}