package com.bytedance.ttgame.main.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;

import androidx.annotation.IntDef;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.bytedance.ttgame.core.SdkConfig;
import com.bytedance.ttgame.framework.module.callback.ICallback;
import com.bytedance.ttgame.framework.module.spi.IModuleApi;
import com.bytedance.ttgame.framework.module.spi.annotation.InternalApi;
import com.bytedance.ttgame.rocketapi.privacy.IPermissionReqListener;
import com.just.agentweb.IAgentWebSettings;
import com.just.agentweb.WebViewClient;

import org.json.JSONObject;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

import timber.log.Timber;

import static com.bytedance.ttgame.main.internal.IMainInternalService.SchedulerType.BACKGROUND;
import static com.bytedance.ttgame.main.internal.IMainInternalService.SchedulerType.DEFAULT;
import static com.bytedance.ttgame.main.internal.IMainInternalService.SchedulerType.IDLE;
import static com.bytedance.ttgame.main.internal.IMainInternalService.SchedulerType.MAIN;
import static com.bytedance.ttgame.main.internal.IMainInternalService.SchedulerType.SERIAL;

/**
 * 内部 API，游戏 APP 请勿调用！
 */
@InternalApi
public interface IMainInternalService extends IModuleApi {
    Context getAppContext();

    String getDeviceId();

    String getInstallId();

    String getPangoLinkChannel(Context context);

    void isEmulator(ICallback<EmulatorResult> iCallback);

    SdkConfig getSdkConfig();

    String getEnv();

    Map<String, Object> getChannelConfig();

    String getApplogSession();

    void sendLog(String event, JSONObject eventParams);

    void sendLog(boolean addPrefix, String event, JSONObject eventParams);

    void monitorCommonLog(String event, JSONObject params);

    void monitorEvent(String serviceName, JSONObject category, JSONObject metric, JSONObject extraLog);

    void monitorSLA(long sendDuration, long sendTime, String sendUrl,
                    String sendIp, String traceCode, int status, JSONObject extJson);

    void monitorApiError(long duration, long sendTime, String sendUrl, String sendIp,
                         String traceCode, int status, JSONObject extJson);

    void monitorStatusRate(String serviceName, int status, JSONObject logExtr);

    void monitorDuration(String serviceName, JSONObject duration, JSONObject logExtr);

    void alog(LogLevel level, String tag, String msg);

    String getCurrentLanguage();

    Context changeContextLocale(Context context);

    void appLogUpdateCustomHeaders();

    Bundle appLogGetCustomHeaders();

    IAgentWebSettings generateWebSettings();

    WebViewClient newSslWebViewClient();

    Timber.DebugTree newThreadAwareDebugTree();

    enum LogLevel {
        DEBUG, INFO, WARN, ERROR
    }

    @IntDef(value = {DEFAULT, BACKGROUND, SERIAL, MAIN, IDLE})
    @Retention(RetentionPolicy.SOURCE)
    @interface SchedulerType {
        int DEFAULT = 0;
        int BACKGROUND = 1;
        int SERIAL = 2;
        int MAIN = 3;
        int IDLE = 4;
    }

    @NonNull ExecutorService getExecutor(@SchedulerType int type);

    @NonNull ScheduledExecutorService getScheduledExecutor();

    int getMemoryLevel();

    /**
     * 初始化网络
     * @param netHook 由于api不能依赖二方库，这里定义为object
     */
    void initNet(Context app, Object netHook);

    boolean isDebug();

    void setDebug(boolean debug);

    /**
     * 接口使用情况埋点
     * <a href="https://bytedance.feishu.cn/docs/doccnTdcetu55HqQHGqE1zgAo7b">参考文档</a>
     * @param interfaceName 接口名称, 取值为接口对应的 unity bridge 接口字符串标识
     * @param params 接口入参, key 的取值为参数对应的 unity bridge 接口参数标识
     */
    void sendItfStatistics(@NonNull String interfaceName, @Nullable Map<String, Object> params);

    boolean geoNameIdWhiteList();

    /**
     * 动态申请权限
     *
     * @param activity
     * @param permissions 申请权限列表
     * @param reqListener 权限申请监听器
     */
    void requestPermission(Activity activity, String[] permissions, IPermissionReqListener reqListener);

    /**
     * 处理权限申请结果
     *
     * @param activity
     * @param requestCode
     * @param permissions
     * @param grantResults
     */
    void dispatchPermissionResult(Activity activity, int requestCode, @NonNull String[] permissions,
                                  @NonNull int[] grantResults);
}
