package com.bytedance.ttgame.main.internal;

import android.content.Context;

import com.bytedance.ttgame.framework.module.spi.IModuleApi;
import com.bytedance.ttgame.framework.module.spi.annotation.InternalApi;

@InternalApi
public interface IGameSdkConfigService extends IModuleApi {
    /**
     * 海外版SDK AID
     */
    public final static int OVERSEA_AID = 1782;
    /**
     * 国内版SDK AID
     */
    public final static int DOMESTIC_AID = 1781;
    /**
     * 国内sdk 云平台appid
     */
    public final static int DOMESTIC_SDK_APP_ID = 2292;
    /**
     * 海外sdk 云平台appid
     */
    public final static int OVERSEA_SDK_APP_ID = 2293;

    public final static String LOGOUT_BROADCAST_ACTION = "com.bytedance.ttgame.module.account.LOGOUT";
    public final static String LOGOUT_BROADCAST_DATA_SDKOPENID = "gsdk_sdk_open_id";

    void init(Context context);

    boolean isIsSwitchLogout();

    void setIsSwitchLogout(boolean isSwitchLogout);

    boolean isIsExitLogout();

    void setIsExitLogout(boolean isExitLogout);

    boolean setUniqueId(String uniqueId);

    String getUniqueId();

    String getAccessToken();

    void setAccessToken(String accessToken);

    void setAdid(String adidId);

    String getAdid();

    String getsUniqueIdLast();

    long getsUserId();

    void setsUserId(long userId);

    String getLoginWay();

    void setLoginWay(String loginWay);

    String getAwemeName();

    void setAwemeName(String awemeName);

    String getUserCreateTime();

    void setUserCreateTime(String userCreateTime);

    boolean getsIsVerify();

    void setsIsVerify(boolean sIsVerify);

    int getAgeType();

    void setAgeType(int ageType);

    void setGMPatchVersion(String gmPathVersion);

    String getGMPatchVersion();

    String getLoginId();

    void setLoginId();

    int getUiFlag();

    void setUiFlag(int uiFlag);

    boolean isIsCreateVisitor();

    void setIsCreateVisitor(boolean isCreateVisitor);

    //在调用登录的时候set进来，取值范围：auto（自动登录）、history（历史账号面板登录）、one_click（抖音手机号一键登录）
    void setLoginType(String loginType);

    String getLoginType();

    String getPhoneLoginType();

    //在调用手机号登录的时候set进来，取值范围：password（密码）、message（验证码）
    void setPhoneLoginType(String phoneLoginType);

    /**
     * 设置开始上报mgame_login_call埋点的时间
     */
    long getStartSendLoginCallTime();

    void setStartSendLoginCallTime(long startSendLoginCallTime);

    long getAuthPassportLoginResDuration();

    void setAuthPassportLoginResDuration(long authPassportLoginResDuration);

    long getFirstLoginShowTime();

    void setFirstLoginShowTime(long firstLoginShowTime);

    boolean isLogining();

    void setIsLogining(boolean isLogining);

    /**
     * 清除聚合登录信息
     */
    void resetUserInfo();

    /**
     * 获取gsdk整体的版本号，未必等于每个组件的版本号
     *
     * @return
     */
    String getSdkVersion();

    String getGlobalSdkVersion();

    void setBoeHeader(String boeHeader);

    String getBoeHeader();

    void setSourceToActivation(String source);

    String getSourceToActivation();

    String getRoleId();

    void setRoleId(String roleId);

    String getServerId();

    void setServerId(String serverId);

    String getRoleName();

    void setRoleName(String roleName);
}
