/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v4.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.FrameLayout;
import com.just.agentweb.EventInterceptor;
import com.just.agentweb.IVideo;
import java.util.HashSet;
import java.util.Set;

public class VideoImpl
implements IVideo,
EventInterceptor {
    private Activity mActivity;
    private WebView mWebView;
    private static final String TAG = VideoImpl.class.getSimpleName();
    private Set<Pair<Integer, Integer>> mFlags = null;
    private View mMoiveView = null;
    private ViewGroup mMoiveParentView = null;
    private WebChromeClient.CustomViewCallback mCallback;

    public VideoImpl(Activity mActivity, WebView webView) {
        this.mActivity = mActivity;
        this.mWebView = webView;
        this.mFlags = new HashSet<Pair<Integer, Integer>>();
    }

    @Override
    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        Activity mActivity = this.mActivity;
        if (mActivity == null || mActivity.isFinishing()) {
            return;
        }
        mActivity.setRequestedOrientation(0);
        Window mWindow = mActivity.getWindow();
        Pair mPair = null;
        if ((mWindow.getAttributes().flags & 0x80) == 0) {
            mPair = new Pair((Object)128, (Object)0);
            mWindow.setFlags(128, 128);
            this.mFlags.add((Pair<Integer, Integer>)mPair);
        }
        if (Build.VERSION.SDK_INT >= 11 && (mWindow.getAttributes().flags & 0x1000000) == 0) {
            mPair = new Pair((Object)0x1000000, (Object)0);
            mWindow.setFlags(0x1000000, 0x1000000);
            this.mFlags.add((Pair<Integer, Integer>)mPair);
        }
        if (this.mMoiveView != null) {
            callback.onCustomViewHidden();
            return;
        }
        if (this.mWebView != null) {
            this.mWebView.setVisibility(8);
        }
        if (this.mMoiveParentView == null) {
            FrameLayout mDecorView = (FrameLayout)mActivity.getWindow().getDecorView();
            this.mMoiveParentView = new FrameLayout((Context)mActivity);
            this.mMoiveParentView.setBackgroundColor(-16777216);
            mDecorView.addView((View)this.mMoiveParentView);
        }
        this.mCallback = callback;
        this.mMoiveView = view;
        this.mMoiveParentView.addView(this.mMoiveView);
        this.mMoiveParentView.setVisibility(0);
    }

    @Override
    public void onHideCustomView() {
        if (this.mMoiveView == null) {
            return;
        }
        if (this.mActivity != null && this.mActivity.getRequestedOrientation() != 1) {
            this.mActivity.setRequestedOrientation(1);
        }
        if (!this.mFlags.isEmpty()) {
            for (Pair<Integer, Integer> mPair : this.mFlags) {
                this.mActivity.getWindow().setFlags(((Integer)mPair.second).intValue(), ((Integer)mPair.first).intValue());
            }
            this.mFlags.clear();
        }
        this.mMoiveView.setVisibility(8);
        if (this.mMoiveParentView != null && this.mMoiveView != null) {
            this.mMoiveParentView.removeView(this.mMoiveView);
        }
        if (this.mMoiveParentView != null) {
            this.mMoiveParentView.setVisibility(8);
        }
        if (this.mCallback != null) {
            this.mCallback.onCustomViewHidden();
        }
        this.mMoiveView = null;
        if (this.mWebView != null) {
            this.mWebView.setVisibility(0);
        }
    }

    @Override
    public boolean isVideoState() {
        return this.mMoiveView != null;
    }

    @Override
    public boolean event() {
        if (this.isVideoState()) {
            this.onHideCustomView();
            return true;
        }
        return false;
    }
}

