/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import java.util.Map;

public class HttpHeaders {
    private final Map<String, Map<String, String>> mHeaders = new ArrayMap();

    public static HttpHeaders create() {
        return new HttpHeaders();
    }

    HttpHeaders() {
    }

    public Map<String, String> getHeaders(String url) {
        String subUrl = this.subBaseUrl(url);
        if (this.mHeaders.get(subUrl) == null) {
            ArrayMap headers = new ArrayMap();
            this.mHeaders.put(subUrl, (Map<String, String>)headers);
            return headers;
        }
        return this.mHeaders.get(subUrl);
    }

    public void additionalHttpHeader(String url, String k, String v) {
        if (null == url) {
            return;
        }
        url = this.subBaseUrl(url);
        Map<String, Map<String, String>> mHeaders = this.getHeaders();
        ArrayMap headersMap = mHeaders.get(this.subBaseUrl(url));
        if (null == headersMap) {
            headersMap = new ArrayMap();
        }
        headersMap.put(k, v);
        mHeaders.put(url, (Map<String, String>)headersMap);
    }

    public void additionalHttpHeaders(String url, Map<String, String> headers) {
        if (null == url) {
            return;
        }
        String subUrl = this.subBaseUrl(url);
        Map<String, Map<String, String>> mHeaders = this.getHeaders();
        ArrayMap headersMap = headers;
        if (null == headersMap) {
            headersMap = new ArrayMap();
        }
        mHeaders.put(subUrl, (Map<String, String>)headersMap);
    }

    public void removeHttpHeader(String url, String k) {
        if (null == url) {
            return;
        }
        String subUrl = this.subBaseUrl(url);
        Map<String, Map<String, String>> mHeaders = this.getHeaders();
        Map<String, String> headersMap = mHeaders.get(subUrl);
        if (null != headersMap) {
            headersMap.remove(k);
        }
    }

    public boolean isEmptyHeaders(String url) {
        Map<String, String> heads = this.getHeaders(url = this.subBaseUrl(url));
        return heads == null || heads.isEmpty();
    }

    public Map<String, Map<String, String>> getHeaders() {
        return this.mHeaders;
    }

    private String subBaseUrl(String originUrl) {
        if (TextUtils.isEmpty((CharSequence)originUrl)) {
            return originUrl;
        }
        int index = originUrl.indexOf("?");
        if (index <= 0) {
            return originUrl;
        }
        String subBaseUrl = originUrl.substring(0, index);
        return subBaseUrl;
    }

    public String toString() {
        return "HttpHeaders{mHeaders=" + this.mHeaders + '}';
    }
}

