/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.webkit.WebView;
import android.widget.FrameLayout;
import com.just.agentweb.AgentWebConfig;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.AgentWebView;
import com.just.agentweb.BaseIndicatorSpec;
import com.just.agentweb.BaseIndicatorView;
import com.just.agentweb.IWebLayout;
import com.just.agentweb.LogUtils;
import com.just.agentweb.R;
import com.just.agentweb.WebCreator;
import com.just.agentweb.WebIndicator;
import com.just.agentweb.WebParentLayout;

public class DefaultWebCreator
implements WebCreator {
    private Activity mActivity;
    private ViewGroup mViewGroup;
    private boolean mIsNeedDefaultProgress;
    private int mIndex;
    private BaseIndicatorView mProgressView;
    private ViewGroup.LayoutParams mLayoutParams = null;
    private int mColor = -1;
    private int mHeight;
    private boolean mIsCreated = false;
    private IWebLayout mIWebLayout;
    private BaseIndicatorSpec mBaseIndicatorSpec;
    private WebView mWebView = null;
    private FrameLayout mFrameLayout = null;
    private View mTargetProgress;
    private static final String TAG = DefaultWebCreator.class.getSimpleName();

    protected DefaultWebCreator(@NonNull Activity activity, @Nullable ViewGroup viewGroup, ViewGroup.LayoutParams lp, int index, int color2, int mHeight, WebView webView, IWebLayout webLayout) {
        this.mActivity = activity;
        this.mViewGroup = viewGroup;
        this.mIsNeedDefaultProgress = true;
        this.mIndex = index;
        this.mColor = color2;
        this.mLayoutParams = lp;
        this.mHeight = mHeight;
        this.mWebView = webView;
        this.mIWebLayout = webLayout;
    }

    protected DefaultWebCreator(@NonNull Activity activity, @Nullable ViewGroup viewGroup, ViewGroup.LayoutParams lp, int index, @Nullable WebView webView, IWebLayout webLayout) {
        this.mActivity = activity;
        this.mViewGroup = viewGroup;
        this.mIsNeedDefaultProgress = false;
        this.mIndex = index;
        this.mLayoutParams = lp;
        this.mWebView = webView;
        this.mIWebLayout = webLayout;
    }

    protected DefaultWebCreator(@NonNull Activity activity, @Nullable ViewGroup viewGroup, ViewGroup.LayoutParams lp, int index, BaseIndicatorView progressView, WebView webView, IWebLayout webLayout) {
        this.mActivity = activity;
        this.mViewGroup = viewGroup;
        this.mIsNeedDefaultProgress = false;
        this.mIndex = index;
        this.mLayoutParams = lp;
        this.mProgressView = progressView;
        this.mWebView = webView;
        this.mIWebLayout = webLayout;
    }

    public void setWebView(WebView webView) {
        this.mWebView = webView;
    }

    public FrameLayout getFrameLayout() {
        return this.mFrameLayout;
    }

    public View getTargetProgress() {
        return this.mTargetProgress;
    }

    public void setTargetProgress(View targetProgress) {
        this.mTargetProgress = targetProgress;
    }

    @Override
    public DefaultWebCreator create() {
        if (this.mIsCreated) {
            return this;
        }
        this.mIsCreated = true;
        ViewGroup mViewGroup = this.mViewGroup;
        if (mViewGroup == null) {
            this.mFrameLayout = (FrameLayout)this.createLayout();
            mViewGroup = this.mFrameLayout;
            this.mActivity.setContentView((View)mViewGroup);
        } else if (this.mIndex == -1) {
            this.mFrameLayout = (FrameLayout)this.createLayout();
            mViewGroup.addView((View)this.mFrameLayout, this.mLayoutParams);
        } else {
            this.mFrameLayout = (FrameLayout)this.createLayout();
            mViewGroup.addView((View)this.mFrameLayout, this.mIndex, this.mLayoutParams);
        }
        return this;
    }

    @Override
    public WebView getWebView() {
        return this.mWebView;
    }

    @Override
    public FrameLayout getWebParentLayout() {
        return this.mFrameLayout;
    }

    private ViewGroup createLayout() {
        View view;
        Activity mActivity = this.mActivity;
        WebParentLayout mFrameLayout = new WebParentLayout((Context)mActivity);
        mFrameLayout.setId(R.id.web_parent_layout_id);
        mFrameLayout.setBackgroundColor(-1);
        if (this.mIWebLayout == null) {
            this.mWebView = this.createWebView();
            view = this.mWebView;
        } else {
            view = this.webLayout();
        }
        View target = view;
        FrameLayout.LayoutParams mLayoutParams = new FrameLayout.LayoutParams(-1, -1);
        mFrameLayout.addView(target, (ViewGroup.LayoutParams)mLayoutParams);
        mFrameLayout.bindWebView(this.mWebView);
        LogUtils.i(TAG, "  instanceof  AgentWebView:" + (this.mWebView instanceof AgentWebView));
        if (this.mWebView instanceof AgentWebView) {
            AgentWebConfig.WEBVIEW_TYPE = 2;
        }
        ViewStub mViewStub = new ViewStub((Context)mActivity);
        mViewStub.setId(R.id.mainframe_error_viewsub_id);
        mFrameLayout.addView((View)mViewStub, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        if (this.mIsNeedDefaultProgress) {
            FrameLayout.LayoutParams lp = null;
            WebIndicator mWebIndicator = new WebIndicator((Context)mActivity);
            lp = this.mHeight > 0 ? new FrameLayout.LayoutParams(-2, AgentWebUtils.dp2px((Context)mActivity, this.mHeight)) : mWebIndicator.offerLayoutParams();
            if (this.mColor != -1) {
                mWebIndicator.setColor(this.mColor);
            }
            lp.gravity = 48;
            this.mBaseIndicatorSpec = mWebIndicator;
            mFrameLayout.addView((View)this.mBaseIndicatorSpec, (ViewGroup.LayoutParams)lp);
            mWebIndicator.setVisibility(8);
        } else if (!this.mIsNeedDefaultProgress && this.mProgressView != null) {
            this.mBaseIndicatorSpec = this.mProgressView;
            mFrameLayout.addView((View)this.mBaseIndicatorSpec, (ViewGroup.LayoutParams)this.mProgressView.offerLayoutParams());
            this.mProgressView.setVisibility(8);
        }
        return mFrameLayout;
    }

    private View webLayout() {
        WebView mWebView = null;
        Object t = this.mIWebLayout.getWebView();
        mWebView = (WebView)t;
        if (t == null) {
            mWebView = this.createWebView();
            this.mIWebLayout.getLayout().addView((View)mWebView, -1, -1);
            LogUtils.i(TAG, "add webview");
        } else {
            AgentWebConfig.WEBVIEW_TYPE = 3;
        }
        this.mWebView = mWebView;
        return this.mIWebLayout.getLayout();
    }

    private WebView createWebView() {
        WebView mWebView = null;
        if (this.mWebView != null) {
            mWebView = this.mWebView;
            AgentWebConfig.WEBVIEW_TYPE = 3;
        } else if (AgentWebConfig.IS_KITKAT_OR_BELOW_KITKAT) {
            mWebView = new AgentWebView((Context)this.mActivity);
            AgentWebConfig.WEBVIEW_TYPE = 2;
        } else {
            mWebView = new WebView((Context)this.mActivity);
            AgentWebConfig.WEBVIEW_TYPE = 1;
        }
        return mWebView;
    }

    public BaseIndicatorSpec offer() {
        return this.mBaseIndicatorSpec;
    }
}

