/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.webkit.DownloadListener;
import android.webkit.WebView;
import com.download.library.DownloadImpl;
import com.download.library.DownloadListenerAdapter;
import com.download.library.Extra;
import com.download.library.ResourceRequest;
import com.just.agentweb.AbsAgentWebUIController;
import com.just.agentweb.Action;
import com.just.agentweb.ActionActivity;
import com.just.agentweb.AgentWebConfig;
import com.just.agentweb.AgentWebPermissions;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.LogUtils;
import com.just.agentweb.PermissionInterceptor;
import com.just.agentweb.R;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultDownloadImpl
implements DownloadListener {
    protected Context mContext;
    protected ConcurrentHashMap<String, ResourceRequest> mDownloadTasks = new ConcurrentHashMap();
    protected WeakReference<Activity> mActivityWeakReference = null;
    private static final String TAG = DefaultDownloadImpl.class.getSimpleName();
    protected PermissionInterceptor mPermissionListener = null;
    protected WeakReference<AbsAgentWebUIController> mAgentWebUIController;
    private static Handler mHandler = new Handler(Looper.getMainLooper());

    protected DefaultDownloadImpl(Activity activity, WebView webView, PermissionInterceptor permissionInterceptor) {
        this.mContext = activity.getApplicationContext();
        this.mActivityWeakReference = new WeakReference<Activity>(activity);
        this.mPermissionListener = permissionInterceptor;
        this.mAgentWebUIController = new WeakReference<AbsAgentWebUIController>(AgentWebUtils.getAgentWebUIControllerByWebView(webView));
    }

    public void onDownloadStart(final String url, final String userAgent, final String contentDisposition, final String mimetype, final long contentLength) {
        mHandler.post(new Runnable(){

            @Override
            public void run() {
                DefaultDownloadImpl.this.onDownloadStartInternal(url, userAgent, contentDisposition, mimetype, contentLength);
            }
        });
    }

    protected void onDownloadStartInternal(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
        if (null == this.mActivityWeakReference.get() || ((Activity)this.mActivityWeakReference.get()).isFinishing()) {
            return;
        }
        if (null != this.mPermissionListener && this.mPermissionListener.intercept(url, AgentWebPermissions.STORAGE, "download")) {
            return;
        }
        ResourceRequest resourceRequest = this.createResourceRequest(url);
        this.mDownloadTasks.put(url, resourceRequest);
        if (Build.VERSION.SDK_INT >= 23) {
            List<String> mList = null;
            mList = this.checkNeedPermission();
            if (mList.isEmpty()) {
                this.preDownload(url);
            } else {
                Action mAction = Action.createPermissionsAction(mList.toArray(new String[0]));
                ActionActivity.setPermissionListener(this.getPermissionListener(url));
                ActionActivity.start((Activity)this.mActivityWeakReference.get(), mAction);
            }
        } else {
            this.preDownload(url);
        }
    }

    protected ResourceRequest createResourceRequest(String url) {
        return DownloadImpl.getInstance().with(url).setEnableIndicator(true).autoOpenIgnoreMD5();
    }

    protected ActionActivity.PermissionListener getPermissionListener(final String url) {
        return new ActionActivity.PermissionListener(){

            @Override
            public void onRequestPermissionsResult(@NonNull String[] permissions, @NonNull int[] grantResults, Bundle extras) {
                if (DefaultDownloadImpl.this.checkNeedPermission().isEmpty()) {
                    DefaultDownloadImpl.this.preDownload(url);
                } else {
                    if (null != DefaultDownloadImpl.this.mAgentWebUIController.get()) {
                        ((AbsAgentWebUIController)DefaultDownloadImpl.this.mAgentWebUIController.get()).onPermissionsDeny(DefaultDownloadImpl.this.checkNeedPermission().toArray(new String[0]), "Storage", "Download");
                    }
                    LogUtils.e(TAG, "\u50a8\u5b58\u6743\u9650\u83b7\u53d6\u5931\u8d25~");
                }
            }
        };
    }

    protected List<String> checkNeedPermission() {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        if (!AgentWebUtils.hasPermission((Context)this.mActivityWeakReference.get(), AgentWebPermissions.STORAGE)) {
            deniedPermissions.addAll(Arrays.asList(AgentWebPermissions.STORAGE));
        }
        return deniedPermissions;
    }

    protected void preDownload(String url) {
        if (!this.isForceRequest(url) && AgentWebUtils.checkNetworkType(this.mContext) > 1) {
            this.showDialog(url);
            return;
        }
        this.performDownload(url);
    }

    protected boolean isForceRequest(String url) {
        ResourceRequest resourceRequest = this.mDownloadTasks.get(url);
        if (null != resourceRequest) {
            return resourceRequest.getDownloadTask().isForceDownload();
        }
        return false;
    }

    protected void forceDownload(String url) {
        ResourceRequest resourceRequest = this.mDownloadTasks.get(url);
        resourceRequest.setForceDownload(true);
        this.performDownload(url);
    }

    protected void showDialog(String url) {
        Activity mActivity = (Activity)this.mActivityWeakReference.get();
        if (null == mActivity || mActivity.isFinishing()) {
            return;
        }
        AbsAgentWebUIController mAgentWebUIController = (AbsAgentWebUIController)this.mAgentWebUIController.get();
        if (null != mAgentWebUIController) {
            mAgentWebUIController.onForceDownloadAlert(url, this.createCallback(url));
        }
    }

    protected Handler.Callback createCallback(final String url) {
        return new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                DefaultDownloadImpl.this.forceDownload(url);
                return true;
            }
        };
    }

    protected void performDownload(String url) {
        block4: {
            try {
                LogUtils.e(TAG, "performDownload:" + url + " exist:" + DownloadImpl.getInstance().exist(url));
                if (DownloadImpl.getInstance().exist(url)) {
                    if (null != this.mAgentWebUIController.get()) {
                        ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onShowMessage(((Activity)this.mActivityWeakReference.get()).getString(R.string.agentweb_download_task_has_been_exist), "preDownload");
                    }
                    return;
                }
                ResourceRequest resourceRequest = this.mDownloadTasks.get(url);
                resourceRequest.addHeader("Cookie", AgentWebConfig.getCookiesByUrl(url));
                this.taskEnqueue(resourceRequest);
            }
            catch (Throwable ignore) {
                if (!LogUtils.isDebug()) break block4;
                ignore.printStackTrace();
            }
        }
    }

    protected void taskEnqueue(ResourceRequest resourceRequest) {
        resourceRequest.enqueue(new DownloadListenerAdapter(){

            public boolean onResult(Throwable throwable, Uri path, String url, Extra extra) {
                DefaultDownloadImpl.this.mDownloadTasks.remove(url);
                return super.onResult(throwable, path, url, extra);
            }
        });
    }

    public static DefaultDownloadImpl create(@NonNull Activity activity, @NonNull WebView webView, @Nullable PermissionInterceptor permissionInterceptor) {
        block2: {
            try {
                DownloadImpl.getInstance().with((Context)activity.getApplication());
            }
            catch (Throwable throwable) {
                LogUtils.e(TAG, "implementation 'com.download.library:Downloader:x.x.x'");
                if (!LogUtils.isDebug()) break block2;
                throwable.printStackTrace();
            }
        }
        return new DefaultDownloadImpl(activity, webView, permissionInterceptor);
    }
}

