/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.coverage_lib;

import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import com.ss.android.ugc.bytex.coverage_lib.CoveragePlugin;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DemoCoverageImp
implements CoveragePlugin {
    private ConcurrentHashMap<Integer, Integer> hashMap = new ConcurrentHashMap(10000);
    private int interval = 120000;
    private long nextReportTime = System.currentTimeMillis() + (long)this.interval;
    private static final String TAG = "CoveragePlugin";
    private static final float K = 1024.0f;
    private static ExecutorService service;

    private DemoCoverageImp() {
        service = Executors.newSingleThreadExecutor();
        this.initIdleHandler();
    }

    private void initIdleHandler() {
        Log.d((String)TAG, (String)"init coverage plugin idleHandler");
        Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

            public boolean queueIdle() {
                if (System.currentTimeMillis() > DemoCoverageImp.this.nextReportTime) {
                    if (DemoCoverageImp.this.hashMap.size() >= 20) {
                        service.execute(new Runnable(){

                            @Override
                            public void run() {
                                StringBuilder stringBuilder = new StringBuilder();
                                for (Map.Entry entry : DemoCoverageImp.this.hashMap.entrySet()) {
                                    stringBuilder.append(entry.getKey()).append(" ").append(entry.getValue()).append("\n");
                                }
                                Log.d((String)DemoCoverageImp.TAG, (String)("coverage report length : " + stringBuilder.length() + " cost byte before compress: " + (float)stringBuilder.length() / 1024.0f + " KB"));
                                DemoCoverageImp.this.hashMap.clear();
                            }
                        });
                    }
                    DemoCoverageImp.this.nextReportTime = System.currentTimeMillis() + (long)DemoCoverageImp.this.interval;
                }
                return true;
            }
        });
    }

    public static DemoCoverageImp getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public void addData(int id) {
        Integer value = this.hashMap.get(id);
        if (value == null) {
            this.hashMap.put(id, 1);
        } else {
            this.hashMap.put(id, value + 1);
        }
    }

    private static class SingletonHolder {
        private static final DemoCoverageImp INSTANCE = new DemoCoverageImp();

        private SingletonHolder() {
        }
    }
}

