/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.RuleException;
import com.buschmais.jqassistant.core.analysis.api.RuleSetReader;
import com.buschmais.jqassistant.core.analysis.api.rule.AggregationVerification;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.CypherExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Executable;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.Report;
import com.buschmais.jqassistant.core.analysis.api.rule.RowCountVerification;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSetBuilder;
import com.buschmais.jqassistant.core.analysis.api.rule.ScriptExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.analysis.api.rule.Verification;
import com.buschmais.jqassistant.core.analysis.api.rule.source.RuleSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.ast.ContentPart;
import org.asciidoctor.ast.StructuredDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciiDocRuleSetReader
implements RuleSetReader {
    private static final Set<String> EXECUTABLE_RULE_TYPES = new HashSet<String>(Arrays.asList("concept", "constraint"));
    private static final Logger LOGGER = LoggerFactory.getLogger(AsciiDocRuleSetReader.class);
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile("(.*?)(\\((.*)\\))?");
    private Asciidoctor cachedAsciidoctor = null;

    @Override
    public void read(List<? extends RuleSource> sources, RuleSetBuilder ruleSetBuilder) throws RuleException {
        for (RuleSource ruleSource : sources) {
            if (!ruleSource.isType(RuleSource.Type.AsciiDoc)) continue;
            this.readDocument(ruleSource, ruleSetBuilder);
        }
    }

    private void readDocument(RuleSource source, RuleSetBuilder builder) throws RuleException {
        InputStream stream;
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("STRUCTURE_MAX_LEVEL", 10);
        try {
            stream = source.getInputStream();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read rules from '" + source.getId() + "'.", e);
        }
        StructuredDocument doc = this.getAsciidoctor().readDocumentStructure((Reader)new InputStreamReader(stream), parameters);
        this.extractExecutableRules(source, doc, builder);
        this.extractGroups(source, doc, builder);
    }

    private Asciidoctor getAsciidoctor() {
        if (this.cachedAsciidoctor == null) {
            LOGGER.debug("Creating Asciidoctor instance.");
            this.cachedAsciidoctor = Asciidoctor.Factory.create();
        }
        return this.cachedAsciidoctor;
    }

    private void extractExecutableRules(RuleSource ruleSource, StructuredDocument doc, RuleSetBuilder builder) throws RuleException {
        for (ContentPart part : AsciiDocRuleSetReader.findExecutableRules(doc.getParts())) {
            Severity severity;
            Object aggregationColumn;
            Map attributes = part.getAttributes();
            String id = part.getId();
            String description = attributes.get("title").toString();
            HashSet<String> requiresConcepts = new HashSet<String>(this.getDependencies(attributes, "requiresConcepts").keySet());
            Set<String> depends = this.getDependencies(attributes, "depends").keySet();
            if (!depends.isEmpty()) {
                LOGGER.info("Using 'depends' to reference required concepts is deprecated, please use 'requiresConcepts' (source='{}', id='{}'}.", (Object)ruleSource.getId(), (Object)id);
                requiresConcepts.addAll(depends);
            }
            Object language = part.getAttributes().get("language");
            String source = this.unescapeHtml(part.getContent());
            Executable executable = "cypher".equals(language) ? new CypherExecutable(source) : new ScriptExecutable(language.toString(), source);
            boolean aggregation = "aggregation".equals(part.getAttributes().get("verify"));
            Verification verification = aggregation ? new AggregationVerification((aggregationColumn = part.getAttributes().get("aggregationColumn")) != null ? aggregationColumn.toString() : null) : new RowCountVerification();
            Object primaryReportColum = part.getAttributes().get("primaryReportColum");
            Report report = new Report(primaryReportColum != null ? primaryReportColum.toString() : null);
            if ("concept".equals(part.getRole())) {
                severity = this.getSeverity(part, Concept.DEFAULT_SEVERITY);
                Concept concept = new Concept(id, description, ruleSource, severity, null, executable, Collections.emptyMap(), requiresConcepts, verification, report);
                builder.addConcept(concept);
                continue;
            }
            if (!"constraint".equals(part.getRole())) continue;
            severity = this.getSeverity(part, Constraint.DEFAULT_SEVERITY);
            Constraint constraint = new Constraint(id, description, ruleSource, severity, null, executable, Collections.emptyMap(), requiresConcepts, verification, report);
            builder.addConstraint(constraint);
        }
    }

    private void extractGroups(RuleSource ruleSource, StructuredDocument doc, RuleSetBuilder ruleSetBuilder) throws RuleException {
        for (ContentPart contentPart : AsciiDocRuleSetReader.findGroups(doc.getParts())) {
            Map attributes = contentPart.getAttributes();
            Map<String, Severity> constraints = this.getDependencies(attributes, "includesConstraints");
            Map<String, Severity> concepts = this.getDependencies(attributes, "includesConcepts");
            Set<String> groups = this.getDependencies(attributes, "includesGroups").keySet();
            Group group = new Group(contentPart.getId(), contentPart.getTitle(), ruleSource, concepts, constraints, groups);
            ruleSetBuilder.addGroup(group);
        }
    }

    private Map<String, Severity> getDependencies(Map<String, Object> attributes, String attributeName) throws RuleException {
        String attribute = (String)attributes.get(attributeName);
        HashSet<String> dependencies = new HashSet<String>();
        if (attribute != null && !attribute.trim().isEmpty()) {
            dependencies.addAll(Arrays.asList(attribute.split("\\s*,\\s*")));
        }
        HashMap<String, Severity> rules = new HashMap<String, Severity>();
        for (String dependency : dependencies) {
            Matcher matcher = DEPENDENCY_PATTERN.matcher(dependency);
            if (!matcher.matches()) continue;
            String id = matcher.group(1);
            String severityValue = matcher.group(3);
            Severity severity = severityValue != null ? Severity.fromValue(severityValue.toLowerCase()) : null;
            rules.put(id, severity);
        }
        return rules;
    }

    private Severity getSeverity(ContentPart part, Severity defaultSeverity) throws RuleException {
        Object severity = part.getAttributes().get("severity");
        if (severity == null) {
            return defaultSeverity;
        }
        Severity value = Severity.fromValue(severity.toString().toLowerCase());
        return value != null ? value : defaultSeverity;
    }

    private String unescapeHtml(String content) {
        return content.replace("&lt;", "<").replace("&gt;", ">");
    }

    private static Collection<ContentPart> findExecutableRules(Collection<ContentPart> parts) {
        LinkedHashSet<ContentPart> result = new LinkedHashSet<ContentPart>();
        if (parts != null) {
            for (ContentPart part : parts) {
                if ("listing".equals(part.getContext()) && "source".equals(part.getStyle()) && EXECUTABLE_RULE_TYPES.contains(part.getRole())) {
                    result.add(part);
                }
                result.addAll(AsciiDocRuleSetReader.findExecutableRules(part.getParts()));
            }
        }
        return result;
    }

    private static Collection<ContentPart> findGroups(Collection<ContentPart> parts) {
        LinkedHashSet<ContentPart> result = new LinkedHashSet<ContentPart>();
        if (parts != null) {
            for (ContentPart part : parts) {
                if ("group".equals(part.getRole())) {
                    result.add(part);
                }
                result.addAll(AsciiDocRuleSetReader.findGroups(part.getParts()));
            }
        }
        return result;
    }
}

