/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalysisException;
import com.buschmais.jqassistant.core.analysis.api.AnalysisListener;
import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.VerificationStrategy;
import com.buschmais.jqassistant.core.analysis.api.model.ConceptDescriptor;
import com.buschmais.jqassistant.core.analysis.api.rule.AbstractRuleVisitor;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.CypherExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Executable;
import com.buschmais.jqassistant.core.analysis.api.rule.ExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.NoTemplateException;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.ScriptExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.analysis.api.rule.Template;
import com.buschmais.jqassistant.core.analysis.api.rule.TemplateExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Verification;
import com.buschmais.jqassistant.core.analysis.impl.AggregationVerificationStrategy;
import com.buschmais.jqassistant.core.analysis.impl.RowCountVerificationStrategy;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.xo.api.Query;
import com.buschmais.xo.api.XOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;

public class AnalyzerVisitor
extends AbstractRuleVisitor {
    private RuleSet ruleSet;
    private Store store;
    private AnalysisListener reportWriter;
    private Logger logger;
    private ScriptEngineManager scriptEngineManager;
    private Map<Class<? extends Verification>, VerificationStrategy> verificationStrategies = new HashMap<Class<? extends Verification>, VerificationStrategy>();

    public AnalyzerVisitor(RuleSet ruleSet, Store store, AnalysisListener reportWriter, Logger log) {
        this.ruleSet = ruleSet;
        this.store = store;
        this.reportWriter = reportWriter;
        this.logger = log;
        this.scriptEngineManager = new ScriptEngineManager();
        this.registerVerificationStrategy(new RowCountVerificationStrategy());
        this.registerVerificationStrategy(new AggregationVerificationStrategy());
    }

    private void registerVerificationStrategy(VerificationStrategy verificationStrategy) {
        this.verificationStrategies.put(verificationStrategy.getVerificationType(), verificationStrategy);
    }

    @Override
    public void visitConcept(Concept concept, Severity effectiveSeverity) throws AnalysisException {
        try {
            this.store.beginTransaction();
            ConceptDescriptor conceptDescriptor = (ConceptDescriptor)this.store.find(ConceptDescriptor.class, concept.getId());
            if (conceptDescriptor == null) {
                this.logger.info("Applying concept '" + concept.getId() + "' with severity: '" + concept.getSeverity().getInfo(effectiveSeverity) + "'.");
                this.reportWriter.beginConcept(concept);
                this.reportWriter.setResult(this.execute(concept, this.ruleSet, effectiveSeverity));
                conceptDescriptor = (ConceptDescriptor)this.store.create(ConceptDescriptor.class);
                conceptDescriptor.setId(concept.getId());
                this.reportWriter.endConcept();
            }
            this.store.commitTransaction();
        }
        catch (XOException e) {
            this.store.rollbackTransaction();
            throw new AnalysisException("Cannot apply concept " + concept.getId(), e);
        }
    }

    @Override
    public void visitConstraint(Constraint constraint, Severity effectiveSeverity) throws AnalysisException {
        this.logger.info("Validating constraint '" + constraint.getId() + "' with severity: '" + constraint.getSeverity().getInfo(effectiveSeverity) + "'.");
        try {
            this.store.beginTransaction();
            this.reportWriter.beginConstraint(constraint);
            this.reportWriter.setResult(this.execute(constraint, this.ruleSet, effectiveSeverity));
            this.reportWriter.endConstraint();
            this.store.commitTransaction();
        }
        catch (XOException e) {
            this.store.rollbackTransaction();
            throw new AnalysisException("Cannot validate constraint " + constraint.getId(), e);
        }
    }

    @Override
    public void beforeGroup(Group group) throws AnalysisException {
        this.logger.info("Executing group '" + group.getId() + "'");
        this.store.beginTransaction();
        this.reportWriter.beginGroup(group);
        this.store.commitTransaction();
    }

    @Override
    public void afterGroup(Group group) throws AnalysisException {
        this.store.beginTransaction();
        this.reportWriter.endGroup();
        this.store.commitTransaction();
    }

    private <T extends ExecutableRule> Result<T> execute(T executableRule, RuleSet ruleSet, Severity severity) throws AnalysisException {
        return this.execute(executableRule, executableRule.getExecutable(), ruleSet, severity);
    }

    private <T extends ExecutableRule> Result<T> execute(T executableRule, Executable executable, RuleSet ruleSet, Severity severity) throws AnalysisException {
        if (executable instanceof CypherExecutable) {
            return this.executeCypher(executableRule, (CypherExecutable)executable, severity);
        }
        if (executable instanceof ScriptExecutable) {
            return this.executeScript(executableRule, (ScriptExecutable)executable, executableRule, severity);
        }
        if (executable instanceof TemplateExecutable) {
            Template template;
            String templateId = ((TemplateExecutable)executable).getTemplateId();
            try {
                template = (Template)ruleSet.getTemplateBucket().getById(templateId);
            }
            catch (NoTemplateException e) {
                throw new AnalysisException("Unknown template with id " + templateId, e);
            }
            return this.execute(executableRule, template.getExecutable(), ruleSet, severity);
        }
        throw new AnalysisException("Unsupported executable type " + executable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends ExecutableRule> Result<T> executeCypher(T executableRule, CypherExecutable executable, Severity severity) throws AnalysisException {
        String cypher = executable.getStatement();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        try (Query.Result<Query.Result.CompositeRowObject> compositeRowObjects = this.executeQuery(cypher, executableRule.getParameters());){
            ArrayList<String> columnNames = null;
            for (Query.Result.CompositeRowObject rowObject : compositeRowObjects) {
                if (columnNames == null) {
                    columnNames = new ArrayList<String>(rowObject.getColumns());
                }
                LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                for (String columnName : columnNames) {
                    row.put(columnName, rowObject.get(columnName, Object.class));
                }
                rows.add(row);
            }
            Result.Status status = this.verify(executableRule, columnNames, rows);
            Result<T> result = new Result<T>(executableRule, status, severity, columnNames, rows);
            return result;
        }
        catch (Exception e) {
            throw new AnalysisException("Cannot execute query for rule '" + executableRule + "'.", e);
        }
    }

    private <T extends ExecutableRule> Result.Status verify(T executable, List<String> columnNames, List<Map<String, Object>> rows) throws AnalysisException {
        Verification verification = executable.getVerification();
        VerificationStrategy strategy = this.verificationStrategies.get(verification.getClass());
        if (strategy == null) {
            throw new AnalysisException("Result verification not supported: " + verification.getClass().getName());
        }
        return strategy.verify(executable, verification, columnNames, rows);
    }

    private <T extends ExecutableRule> Result<T> executeScript(T executableRule, ScriptExecutable scriptExecutable, T executable, Severity severity) throws AnalysisException {
        Object scriptResult;
        String language = scriptExecutable.getLanguage();
        ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(language);
        if (scriptEngine == null) {
            ArrayList<String> availableLanguages = new ArrayList<String>();
            for (ScriptEngineFactory factory : this.scriptEngineManager.getEngineFactories()) {
                availableLanguages.addAll(factory.getNames());
            }
            throw new AnalysisException("Cannot resolve scripting engine for '" + language + "', available languages are " + availableLanguages);
        }
        scriptEngine.put(ScriptVariable.STORE.getVariableName(), this.store);
        scriptEngine.put(ScriptVariable.RULE.getVariableName(), executable);
        scriptEngine.put(ScriptVariable.SEVERITY.getVariableName(), (Object)severity);
        try {
            scriptResult = scriptEngine.eval(scriptExecutable.getSource());
        }
        catch (ScriptException e) {
            throw new AnalysisException("Cannot execute script.", e);
        }
        if (!(scriptResult instanceof Result)) {
            throw new AnalysisException("Script returned an invalid result language, expected " + Result.class.getName() + " but got " + scriptResult);
        }
        return (Result)Result.class.cast(scriptResult);
    }

    private Query.Result<Query.Result.CompositeRowObject> executeQuery(String cypher, Map<String, Object> parameters) {
        this.logger.debug("Executing query '" + cypher + "' with parameters [" + parameters + "]");
        return this.store.executeQuery(cypher, parameters);
    }

    private static enum ScriptVariable {
        STORE,
        RULE,
        SEVERITY;


        String getVariableName() {
            return this.name().toLowerCase();
        }
    }
}

