/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.api.rule.source;

import com.buschmais.jqassistant.core.analysis.api.rule.source.RuleSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.DirectoryWalker;

public class FileRuleSource
extends RuleSource {
    private File file;

    public FileRuleSource(File file) {
        this.file = file;
    }

    @Override
    protected RuleSource.Type getType() {
        return this.selectTypeById();
    }

    @Override
    public String getId() {
        return this.file.getAbsolutePath();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public static List<RuleSource> getRuleSources(File rulesDirectory) throws IOException {
        final ArrayList ruleFiles = new ArrayList();
        new DirectoryWalker<File>(){

            protected void handleFile(File file, int depth, Collection<File> results) throws IOException {
                boolean isFile = file.isFile();
                boolean isAsciiDocFile = RuleSource.Type.AsciiDoc.matches(file);
                boolean isXMLFile = RuleSource.Type.XML.matches(file);
                if (isFile && (isAsciiDocFile || isXMLFile)) {
                    results.add(file);
                }
            }

            public void scan(File directory) throws IOException {
                super.walk(directory, (Collection)ruleFiles);
            }
        }.scan(rulesDirectory);
        LinkedList<RuleSource> ruleSources = new LinkedList<RuleSource>();
        for (File ruleFile : ruleFiles) {
            ruleSources.add(new FileRuleSource(ruleFile));
        }
        return ruleSources;
    }
}

