/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.api.rule;

import com.buschmais.jqassistant.core.analysis.api.RuleException;
import java.util.EnumSet;

public enum Severity {
    BLOCKER("blocker", 0),
    CRITICAL("critical", 1),
    MAJOR("major", 2),
    MINOR("minor", 3),
    INFO("info", 4);

    private final String value;
    private final Integer level;

    private Severity(String value, Integer level) {
        this.value = value;
        this.level = level;
    }

    public String getValue() {
        return this.value;
    }

    public Integer getLevel() {
        return this.level;
    }

    public static Severity fromValue(String value) throws RuleException {
        if (value == null) {
            return null;
        }
        for (Severity severity : EnumSet.allOf(Severity.class)) {
            if (!severity.value.equals(value)) continue;
            return severity;
        }
        throw new RuleException("Unknown severity '" + value + "'.");
    }

    public static String[] names() {
        int i = 0;
        String[] names = new String[Severity.values().length];
        for (Severity severity : Severity.values()) {
            names[i++] = severity.value;
        }
        return names;
    }

    public String getInfo(Severity effectiveSeverity) {
        StringBuffer result = new StringBuffer(effectiveSeverity.name());
        if (!this.equals((Object)effectiveSeverity)) {
            result.append(" (from ").append(this.name()).append(")");
        }
        return result.toString();
    }
}

