/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.legacy.consistency.checking;

import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.legacy.consistency.RecordType;
import org.neo4j.legacy.consistency.checking.CheckDecorator;
import org.neo4j.legacy.consistency.checking.DynamicRecordCheck;
import org.neo4j.legacy.consistency.checking.DynamicStore;
import org.neo4j.legacy.consistency.checking.LabelTokenRecordCheck;
import org.neo4j.legacy.consistency.checking.NodeDynamicLabelOrphanChainStartCheck;
import org.neo4j.legacy.consistency.checking.NodeRecordCheck;
import org.neo4j.legacy.consistency.checking.PropertyKeyTokenRecordCheck;
import org.neo4j.legacy.consistency.checking.PropertyRecordCheck;
import org.neo4j.legacy.consistency.checking.RecordCheck;
import org.neo4j.legacy.consistency.checking.RelationshipGroupRecordCheck;
import org.neo4j.legacy.consistency.checking.RelationshipRecordCheck;
import org.neo4j.legacy.consistency.checking.RelationshipTypeTokenRecordCheck;
import org.neo4j.legacy.consistency.report.ConsistencyReport;

public abstract class AbstractStoreProcessor
extends RecordStore.Processor<RuntimeException> {
    private final RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> sparseNodeChecker;
    private final RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> denseNodeChecker;
    private final RecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> relationshipChecker;
    private final RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> propertyChecker;
    private final RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> propertyKeyTokenChecker;
    private final RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> relationshipTypeTokenChecker;
    private final RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> labelTokenChecker;
    private final RecordCheck<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> relationshipGroupChecker;

    public AbstractStoreProcessor() {
        this(CheckDecorator.NONE);
    }

    public AbstractStoreProcessor(CheckDecorator decorator) {
        this.sparseNodeChecker = decorator.decorateNodeChecker(NodeRecordCheck.forSparseNodes());
        this.denseNodeChecker = decorator.decorateNodeChecker(NodeRecordCheck.forDenseNodes());
        this.relationshipChecker = decorator.decorateRelationshipChecker(new RelationshipRecordCheck());
        this.propertyChecker = decorator.decoratePropertyChecker(new PropertyRecordCheck());
        this.propertyKeyTokenChecker = decorator.decoratePropertyKeyTokenChecker(new PropertyKeyTokenRecordCheck());
        this.relationshipTypeTokenChecker = decorator.decorateRelationshipTypeTokenChecker(new RelationshipTypeTokenRecordCheck());
        this.labelTokenChecker = decorator.decorateLabelTokenChecker(new LabelTokenRecordCheck());
        this.relationshipGroupChecker = decorator.decorateRelationshipGroupChecker(new RelationshipGroupRecordCheck());
    }

    protected abstract void checkNode(RecordStore<NodeRecord> var1, NodeRecord var2, RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> var3);

    protected abstract void checkRelationship(RecordStore<RelationshipRecord> var1, RelationshipRecord var2, RecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> var3);

    protected abstract void checkProperty(RecordStore<PropertyRecord> var1, PropertyRecord var2, RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> var3);

    protected abstract void checkRelationshipTypeToken(RecordStore<RelationshipTypeTokenRecord> var1, RelationshipTypeTokenRecord var2, RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> var3);

    protected abstract void checkLabelToken(RecordStore<LabelTokenRecord> var1, LabelTokenRecord var2, RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> var3);

    protected abstract void checkPropertyKeyToken(RecordStore<PropertyKeyTokenRecord> var1, PropertyKeyTokenRecord var2, RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> var3);

    protected abstract void checkDynamic(RecordType var1, RecordStore<DynamicRecord> var2, DynamicRecord var3, RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> var4);

    protected abstract void checkDynamicLabel(RecordType var1, RecordStore<DynamicRecord> var2, DynamicRecord var3, RecordCheck<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport> var4);

    protected abstract void checkRelationshipGroup(RecordStore<RelationshipGroupRecord> var1, RelationshipGroupRecord var2, RecordCheck<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> var3);

    public void processSchema(RecordStore<DynamicRecord> store, DynamicRecord schema) {
        this.checkDynamic(RecordType.SCHEMA, store, schema, new DynamicRecordCheck(store, DynamicStore.SCHEMA));
    }

    public final void processNode(RecordStore<NodeRecord> store, NodeRecord node) {
        if (node.isDense()) {
            this.checkNode(store, node, this.denseNodeChecker);
        } else {
            this.checkNode(store, node, this.sparseNodeChecker);
        }
    }

    public final void processRelationship(RecordStore<RelationshipRecord> store, RelationshipRecord rel) {
        this.checkRelationship(store, rel, this.relationshipChecker);
    }

    public final void processProperty(RecordStore<PropertyRecord> store, PropertyRecord property) {
        this.checkProperty(store, property, this.propertyChecker);
    }

    public final void processString(RecordStore<DynamicRecord> store, DynamicRecord string, IdType idType) {
        DynamicStore dereference;
        RecordType type;
        switch (idType) {
            case STRING_BLOCK: {
                type = RecordType.STRING_PROPERTY;
                dereference = DynamicStore.STRING;
                break;
            }
            case RELATIONSHIP_TYPE_TOKEN_NAME: {
                type = RecordType.RELATIONSHIP_TYPE_NAME;
                dereference = DynamicStore.RELATIONSHIP_TYPE;
                break;
            }
            case PROPERTY_KEY_TOKEN_NAME: {
                type = RecordType.PROPERTY_KEY_NAME;
                dereference = DynamicStore.PROPERTY_KEY;
                break;
            }
            case LABEL_TOKEN_NAME: {
                type = RecordType.LABEL_NAME;
                dereference = DynamicStore.LABEL;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The id type [%s] is not valid for String records.", idType));
            }
        }
        this.checkDynamic(type, store, string, new DynamicRecordCheck(store, dereference));
    }

    public final void processArray(RecordStore<DynamicRecord> store, DynamicRecord array) {
        this.checkDynamic(RecordType.ARRAY_PROPERTY, store, array, new DynamicRecordCheck(store, DynamicStore.ARRAY));
    }

    public final void processLabelArrayWithOwner(RecordStore<DynamicRecord> store, DynamicRecord array) {
        this.checkDynamic(RecordType.NODE_DYNAMIC_LABEL, store, array, new DynamicRecordCheck(store, DynamicStore.NODE_LABEL));
        this.checkDynamicLabel(RecordType.NODE_DYNAMIC_LABEL, store, array, new NodeDynamicLabelOrphanChainStartCheck());
    }

    public final void processRelationshipTypeToken(RecordStore<RelationshipTypeTokenRecord> store, RelationshipTypeTokenRecord record) {
        this.checkRelationshipTypeToken(store, record, this.relationshipTypeTokenChecker);
    }

    public final void processPropertyKeyToken(RecordStore<PropertyKeyTokenRecord> store, PropertyKeyTokenRecord record) {
        this.checkPropertyKeyToken(store, record, this.propertyKeyTokenChecker);
    }

    public void processLabelToken(RecordStore<LabelTokenRecord> store, LabelTokenRecord record) {
        this.checkLabelToken(store, record, this.labelTokenChecker);
    }

    public void processRelationshipGroup(RecordStore<RelationshipGroupRecord> store, RelationshipGroupRecord record) throws RuntimeException {
        this.checkRelationshipGroup(store, record, this.relationshipGroupChecker);
    }
}

