/*
 * Decompiled with CFR 0.152.
 */
package sf.util.clparser;

import sf.util.clparser.Option;
import sf.util.clparser.OptionValue;

public abstract class BaseOption<T>
implements Option<T> {
    private final Character shortForm;
    private final String longForm;
    private final T defaultValue;

    protected BaseOption(Character shortForm, String longForm, T defaultValue) {
        this.shortForm = shortForm;
        this.longForm = longForm;
        if (this.shortForm == null && this.longForm == null) {
            throw new IllegalArgumentException("Command line option is not defined");
        }
        this.defaultValue = defaultValue;
    }

    protected BaseOption(Character shortForm, T defaultValue) {
        this(shortForm, null, defaultValue);
    }

    protected BaseOption(String longForm, T defaultValue) {
        this(null, longForm, defaultValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseOption)) {
            return false;
        }
        BaseOption other = (BaseOption)obj;
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.longForm == null ? other.longForm != null : !this.longForm.equals(other.longForm)) {
            return false;
        }
        return !(this.shortForm == null ? other.shortForm != null : !this.shortForm.equals(other.shortForm));
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getLongForm() {
        return this.longForm;
    }

    @Override
    public String getShortForm() {
        return this.shortForm.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.longForm == null ? 0 : this.longForm.hashCode());
        result = 31 * result + (this.shortForm == null ? 0 : this.shortForm.hashCode());
        return result;
    }

    @Override
    public boolean hasLongForm() {
        return this.longForm != null;
    }

    @Override
    public boolean hasShortForm() {
        return this.shortForm != null;
    }

    public String toString() {
        String optionString = "{" + (this.hasShortForm() ? "-" + this.shortForm : "") + (this.hasLongForm() ? "/ -" + this.longForm : "") + (this.defaultValue != null ? " (" + this.defaultValue + ")" : "") + "}";
        return optionString;
    }

    protected abstract OptionValue<T> parseValue(String var1);
}

