/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.utility;

import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.utility.BaseTextFormattingHelper;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import sf.util.Utility;

public class PlainTextFormattingHelper
extends BaseTextFormattingHelper {
    public PlainTextFormattingHelper(TextOutputFormat outputFormat) {
        super(outputFormat);
    }

    @Override
    public String createArrow() {
        return " --> ";
    }

    @Override
    public String createDocumentEnd() {
        return "";
    }

    @Override
    public String createDocumentStart() {
        return "";
    }

    @Override
    public String createHeader(TextFormattingHelper.DocumentHeaderType type, String header) {
        if (!Utility.isBlank(header)) {
            String separator;
            String prefix;
            String defaultSeparator = PlainTextFormattingHelper.separator("=");
            if (type == null) {
                prefix = Utility.NEWLINE;
                separator = defaultSeparator;
            } else {
                switch (type) {
                    case title: {
                        prefix = Utility.NEWLINE;
                        separator = PlainTextFormattingHelper.separator("_");
                        break;
                    }
                    case subTitle: {
                        prefix = Utility.NEWLINE;
                        separator = defaultSeparator;
                        break;
                    }
                    case section: {
                        prefix = "";
                        separator = PlainTextFormattingHelper.separator("-=-");
                        break;
                    }
                    default: {
                        prefix = Utility.NEWLINE;
                        separator = defaultSeparator;
                    }
                }
            }
            return Utility.NEWLINE + prefix + header + Utility.NEWLINE + separator + Utility.NEWLINE + prefix;
        }
        return "";
    }

    @Override
    public String createObjectEnd() {
        return Utility.NEWLINE;
    }

    @Override
    public String createObjectStart(String name) {
        String objectStart = !Utility.isBlank(name) ? Utility.NEWLINE + name + Utility.NEWLINE + DASHED_SEPARATOR : "";
        return objectStart;
    }
}

