/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.Options;

public class ApplicationOptions
implements Options {
    private static final long serialVersionUID = -2497570007150087268L;
    private Level applicationLogLevel;
    private boolean showHelp;
    private boolean showVersionOnly;

    public void applyApplicationLogLevel() {
        if (this.applicationLogLevel == null) {
            return;
        }
        LogManager logManager = LogManager.getLogManager();
        ArrayList<String> loggerNames = Collections.list(logManager.getLoggerNames());
        for (String loggerName : loggerNames) {
            Logger logger = logManager.getLogger(loggerName);
            if (logger == null) continue;
            logger.setLevel(null);
            for (Handler handler : logger.getHandlers()) {
                handler.setLevel(this.applicationLogLevel);
            }
        }
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(this.applicationLogLevel);
    }

    public Level getApplicationLogLevel() {
        return this.applicationLogLevel;
    }

    public boolean isShowHelp() {
        return this.showHelp;
    }

    public boolean isShowVersionOnly() {
        return this.showVersionOnly;
    }

    public void setApplicationLogLevel(Level applicationLogLevel) {
        this.applicationLogLevel = applicationLogLevel;
    }

    public void setShowHelp(boolean showHelp) {
        this.showHelp = showHelp;
    }

    public void setShowVersionOnly(boolean showVersionOnly) {
        this.showVersionOnly = showVersionOnly;
    }
}

