/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.util.logging.Level;
import java.util.logging.Logger;

public enum TableConstraintType {
    unknown("unknown"),
    check("CHECK"),
    unique("UNIQUE"),
    primary_key("PRIMARY KEY"),
    foreign_key("FOREIGN KEY");

    private static final Logger LOGGER;
    private final String value;

    public static TableConstraintType valueOfFromValue(String value) {
        for (TableConstraintType type : TableConstraintType.values()) {
            if (!type.getValue().equalsIgnoreCase(value)) continue;
            return type;
        }
        LOGGER.log(Level.FINE, "Unknown value  " + value);
        return unknown;
    }

    private TableConstraintType(String value) {
        this.value = value;
    }

    public final String getValue() {
        return this.value;
    }

    static {
        LOGGER = Logger.getLogger(TableConstraintType.class.getName());
    }
}

