/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ForeignKeyColumnReference;

final class MutableForeignKeyColumnReference
implements ForeignKeyColumnReference {
    private static final long serialVersionUID = 3689073962672273464L;
    private Column foreignKeyColumn;
    private Column primaryKeyColumn;
    private int keySequence;

    MutableForeignKeyColumnReference() {
    }

    @Override
    public int compareTo(ColumnReference other1) {
        if (other1 == null) {
            return -1;
        }
        if (!(other1 instanceof ForeignKeyColumnReference)) {
            return -1;
        }
        ForeignKeyColumnReference other = (ForeignKeyColumnReference)other1;
        int comparison = 0;
        if (comparison == 0) {
            comparison = this.getKeySequence() - other.getKeySequence();
        }
        if (comparison == 0) {
            comparison = this.getPrimaryKeyColumn().getFullName().compareTo(other.getPrimaryKeyColumn().getFullName());
        }
        if (comparison == 0) {
            comparison = this.getForeignKeyColumn().getFullName().compareTo(other.getForeignKeyColumn().getFullName());
        }
        return comparison;
    }

    @Override
    public Column getForeignKeyColumn() {
        return this.foreignKeyColumn;
    }

    @Override
    public int getKeySequence() {
        return this.keySequence;
    }

    @Override
    public Column getPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    void setForeignKeyColumn(Column foreignKeyColumn) {
        this.foreignKeyColumn = foreignKeyColumn;
    }

    void setKeySequence(int keySequence) {
        this.keySequence = keySequence;
    }

    void setPrimaryKeyColumn(Column primaryKeyColumn) {
        this.primaryKeyColumn = primaryKeyColumn;
    }
}

