/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.rdbms.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.PropertyDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.java.api.model.PropertyFileDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.ConnectionDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.SchemaDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.impl.scanner.AbstractSchemaScannerPlugin;
import com.google.common.base.CaseFormat;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import schemacrawler.tools.options.InfoLevel;

@ScannerPlugin.Requires(value={PropertyFileDescriptor.class})
public class ConnectionPropertyFileScannerPlugin
extends AbstractSchemaScannerPlugin<FileResource, ConnectionDescriptor> {
    public static final String PLUGIN_NAME = "jqassistant.plugin.rdbms";
    public static final String PROPERTIES_SUFFIX = ".properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionPropertyFileScannerPlugin.class);

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        String lowerCase = path.toLowerCase();
        return lowerCase.contains(PLUGIN_NAME) && lowerCase.endsWith(PROPERTIES_SUFFIX);
    }

    public ConnectionDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        PropertyFileDescriptor propertyFileDescriptor = (PropertyFileDescriptor)scanner.getContext().peek(PropertyFileDescriptor.class);
        List propertyDescriptors = propertyFileDescriptor.getProperties();
        String driver = null;
        String url = null;
        String user = null;
        String password = null;
        String infoLevel = InfoLevel.standard.name();
        String bundledDriver = null;
        Properties properties = new Properties();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            String name = propertyDescriptor.getName();
            String value = propertyDescriptor.getValue();
            if (PluginProperty.Driver.matches(name)) {
                driver = value;
                continue;
            }
            if (PluginProperty.Url.matches(name)) {
                url = value;
                continue;
            }
            if (PluginProperty.User.matches(name)) {
                user = value;
                continue;
            }
            if (PluginProperty.Password.matches(name)) {
                password = value;
                continue;
            }
            if (PluginProperty.InfoLevel.matches(name)) {
                infoLevel = value;
                continue;
            }
            if (PluginProperty.BundledDriver.matches(name)) {
                bundledDriver = value;
                continue;
            }
            properties.setProperty(name, value);
        }
        Store store = scanner.getContext().getStore();
        ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)store.addDescriptorType((Descriptor)propertyFileDescriptor, ConnectionDescriptor.class);
        if (url == null) {
            LOGGER.warn(path + " does not contain a driver or url, skipping scan of schema.");
            return connectionDescriptor;
        }
        this.loadDriver(driver);
        List<SchemaDescriptor> schemaDescriptors = this.scanConnection(url, user, password, infoLevel, bundledDriver, properties, store);
        connectionDescriptor.getSchemas().addAll(schemaDescriptors);
        return connectionDescriptor;
    }

    private void loadDriver(String driver) throws IOException {
        if (driver != null) {
            try {
                Class.forName(driver);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(driver + " cannot be loaded, skipping scan of schema.", e);
            }
        }
    }

    private static enum PluginProperty {
        Driver,
        Url,
        User,
        Password,
        InfoLevel,
        BundledDriver;


        boolean matches(String name) {
            return this.name().equals(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, name));
        }
    }
}

