/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.cli.task;

import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.scanner.impl.ScannerContextImpl;
import com.buschmais.jqassistant.core.scanner.impl.ScannerImpl;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.cli.CliConfigurationException;
import com.buschmais.jqassistant.scm.cli.CliExecutionException;
import com.buschmais.jqassistant.scm.cli.task.AbstractTask;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanTask
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanTask.class);
    public static final String CMDLINE_OPTION_FILES = "f";
    public static final String CMDLINE_OPTION_URIS = "u";
    public static final String CMDLINE_OPTION_RESET = "reset";
    private Map<String, String> files = Collections.emptyMap();
    private Map<String, String> urls = Collections.emptyMap();
    private boolean reset = false;

    @Override
    protected void addTaskOptions(List<Option> options) {
        OptionBuilder.withArgName((String)CMDLINE_OPTION_FILES);
        OptionBuilder.withLongOpt((String)"files");
        OptionBuilder.withDescription((String)"The files or directories to be scanned, comma separated, each with optional scope prefix.");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_FILES));
        OptionBuilder.withArgName((String)CMDLINE_OPTION_URIS);
        OptionBuilder.withLongOpt((String)"uris");
        OptionBuilder.withDescription((String)"The URIs to be scanned, comma separated, each with optional scope prefix.");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_URIS));
        OptionBuilder.withArgName((String)CMDLINE_OPTION_RESET);
        OptionBuilder.withDescription((String)"Reset store before scanning (default=false).");
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_RESET));
    }

    @Override
    protected void executeTask(Store store) throws CliExecutionException {
        String scopeName;
        List scannerPlugins;
        ScannerContextImpl scannerContext = new ScannerContextImpl(store);
        try {
            scannerPlugins = this.pluginRepository.getScannerPluginRepository().getScannerPlugins((ScannerContext)scannerContext, this.pluginProperties);
        }
        catch (PluginRepositoryException e) {
            throw new CliExecutionException("Cannot get scanner plugins.", e);
        }
        if (this.reset) {
            store.reset();
        }
        for (Map.Entry<String, String> entry : this.files.entrySet()) {
            String fileName = entry.getKey();
            scopeName = entry.getValue();
            File file = new File(fileName);
            String absolutePath = file.getAbsolutePath();
            if (!file.exists()) {
                LOGGER.info(absolutePath + "' does not exist, skipping scan.");
                continue;
            }
            this.scan((ScannerContext)scannerContext, file, file.getAbsolutePath(), scopeName, scannerPlugins);
        }
        for (Map.Entry<String, String> entry : this.urls.entrySet()) {
            String uri = entry.getKey();
            scopeName = entry.getValue();
            try {
                this.scan((ScannerContext)scannerContext, new URI(uri), uri, scopeName, scannerPlugins);
            }
            catch (URISyntaxException e) {
                throw new CliConfigurationException("Cannot parse URI " + uri, e);
            }
        }
    }

    private Map<String, String> parseResources(List<String> optionValues) {
        HashMap<String, String> resources = new HashMap<String, String>();
        for (String file : optionValues) {
            String fileName;
            String[] parts = file.split("::");
            String scopeName = null;
            if (parts.length == 2) {
                scopeName = parts[0];
                fileName = parts[1];
            } else {
                fileName = parts[0];
            }
            resources.put(fileName, scopeName);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void scan(ScannerContext scannerContext, T element, String path, String scopeName, List<ScannerPlugin<?, ?>> scannerPlugins) throws CliExecutionException {
        ScannerImpl scanner;
        Store store = scannerContext.getStore();
        store.beginTransaction();
        try {
            scanner = new ScannerImpl(scannerContext, scannerPlugins, this.pluginRepository.getScopePluginRepository().getScopes());
        }
        catch (PluginRepositoryException e) {
            throw new CliExecutionException("Cannot get scope plugins.", e);
        }
        Scope scope = scanner.resolveScope(scopeName);
        try {
            scanner.scan(element, path, scope);
        }
        finally {
            store.commitTransaction();
        }
    }

    @Override
    public void withOptions(CommandLine options) throws CliConfigurationException {
        this.files = this.parseResources(this.getOptionValues(options, CMDLINE_OPTION_FILES, Collections.emptyList()));
        this.urls = this.parseResources(this.getOptionValues(options, CMDLINE_OPTION_URIS, Collections.emptyList()));
        if (this.files.isEmpty() && this.urls.isEmpty()) {
            throw new CliConfigurationException("No files, directories or urls given.");
        }
        this.reset = options.hasOption(CMDLINE_OPTION_RESET);
    }
}

