/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.cli.task;

import com.buschmais.jqassistant.core.report.api.ReportTransformerException;
import com.buschmais.jqassistant.core.report.impl.HtmlReportTransformer;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.cli.CliExecutionException;
import com.buschmais.jqassistant.scm.cli.task.AbstractTask;
import com.buschmais.jqassistant.scm.cli.task.ResetTask;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportTask
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResetTask.class);
    public static final String REPORT_FILE_HTML = "jqassistant-report.html";
    private String reportDirectory;

    @Override
    protected void executeTask(Store store) throws CliExecutionException {
        File xmlReportFile = new File(this.reportDirectory, "jqassistant-report.xml");
        if (!xmlReportFile.exists()) {
            LOGGER.error(xmlReportFile.getName() + " does not exist.");
        } else {
            FileWriter writer;
            LOGGER.info("Transforming " + xmlReportFile.getAbsolutePath() + ".");
            File htmlReportFile = new File(this.reportDirectory, REPORT_FILE_HTML);
            StreamSource xmlSource = new StreamSource(xmlReportFile);
            try {
                writer = new FileWriter(htmlReportFile);
            }
            catch (IOException e) {
                throw new CliExecutionException("Cannot create HTML report file.", e);
            }
            StreamResult htmlTarget = new StreamResult(writer);
            HtmlReportTransformer transformer = new HtmlReportTransformer();
            try {
                transformer.toStandalone((Source)xmlSource, (Result)htmlTarget);
            }
            catch (ReportTransformerException e) {
                throw new CliExecutionException("Cannot transform report.", e);
            }
        }
    }

    @Override
    public void withOptions(CommandLine options) {
        this.reportDirectory = this.getOptionValue(options, "reportDirectory", "jqassistant/report");
    }
}

