/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.cli.task;

import com.buschmais.jqassistant.scm.cli.CliExecutionException;
import com.buschmais.jqassistant.scm.cli.Task;
import com.buschmais.jqassistant.scm.cli.TaskFactory;
import com.buschmais.jqassistant.scm.cli.task.AnalyzeTask;
import com.buschmais.jqassistant.scm.cli.task.AvailableRulesTask;
import com.buschmais.jqassistant.scm.cli.task.AvailableScopesTask;
import com.buschmais.jqassistant.scm.cli.task.EffectiveRulesTask;
import com.buschmais.jqassistant.scm.cli.task.ReportTask;
import com.buschmais.jqassistant.scm.cli.task.ResetTask;
import com.buschmais.jqassistant.scm.cli.task.ScanTask;
import com.buschmais.jqassistant.scm.cli.task.ServerTask;
import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.List;

public class DefaultTaskFactoryImpl
implements TaskFactory {
    @Override
    public Task fromName(String name) throws CliExecutionException {
        String formattedTaskName = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, name);
        try {
            return DefaultTask.valueOf(formattedTaskName).getTask();
        }
        catch (IllegalArgumentException e) {
            throw new CliExecutionException("Cannot determine task for " + name);
        }
    }

    @Override
    public List<Task> getTasks() {
        ArrayList<Task> taskNames = new ArrayList<Task>();
        for (DefaultTask defaultTask : DefaultTask.values()) {
            taskNames.add(defaultTask.getTask());
        }
        return taskNames;
    }

    @Override
    public List<String> getTaskNames() {
        ArrayList<String> taskNames = new ArrayList<String>();
        for (DefaultTask defaultTask : DefaultTask.values()) {
            taskNames.add(defaultTask.name().toLowerCase());
        }
        return taskNames;
    }

    private static enum DefaultTask {
        SCAN{

            @Override
            public Task getTask() {
                return new ScanTask();
            }
        }
        ,
        AVAILABLE_SCOPES{

            @Override
            public Task getTask() {
                return new AvailableScopesTask();
            }
        }
        ,
        SERVER{

            @Override
            public Task getTask() {
                return new ServerTask();
            }
        }
        ,
        AVAILABLE_RULES{

            @Override
            public Task getTask() {
                return new AvailableRulesTask();
            }
        }
        ,
        EFFECTIVE_RULES{

            @Override
            public Task getTask() {
                return new EffectiveRulesTask();
            }
        }
        ,
        ANALYZE{

            @Override
            public Task getTask() {
                return new AnalyzeTask();
            }
        }
        ,
        RESET{

            @Override
            public Task getTask() {
                return new ResetTask();
            }
        }
        ,
        REPORT{

            @Override
            public Task getTask() {
                return new ReportTask();
            }
        };


        public abstract Task getTask();
    }
}

