/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.cli.task;

import com.buschmais.jqassistant.core.plugin.api.PluginRepository;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.impl.EmbeddedGraphStore;
import com.buschmais.jqassistant.scm.cli.CliExecutionException;
import com.buschmais.jqassistant.scm.cli.Task;
import com.buschmais.jqassistant.scm.common.report.RuleHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTask
implements Task {
    protected static final String CMDLINE_OPTION_S = "s";
    protected static final String CMDLINE_OPTION_STOREDIRECTORY = "storeDirectory";
    protected static final String CMDLINE_OPTION_REPORTDIR = "reportDirectory";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTask.class);
    protected String storeDirectory;
    protected PluginRepository pluginRepository;
    protected RuleHelper ruleHelper;
    protected ReportHelper reportHelper;
    protected Map<String, Object> pluginProperties;

    @Override
    public void initialize(PluginRepository pluginRepository, Map<String, Object> pluginProperties) throws CliExecutionException {
        this.pluginRepository = pluginRepository;
        this.pluginProperties = pluginProperties;
        this.ruleHelper = new RuleHelper(LOGGER);
        this.reportHelper = new ReportHelper(LOGGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws CliExecutionException {
        List descriptorTypes;
        Store store = this.getStore();
        try {
            descriptorTypes = this.pluginRepository.getModelPluginRepository().getDescriptorTypes();
        }
        catch (PluginRepositoryException e) {
            throw new CliExecutionException("Cannot get model.", e);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.pluginRepository.getClassLoader());
        try {
            store.start((Collection)descriptorTypes);
            this.executeTask(store);
        }
        finally {
            store.stop();
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public void withStandardOptions(CommandLine options) {
        this.storeDirectory = this.getOptionValue(options, CMDLINE_OPTION_S, "jqassistant/store");
    }

    @Override
    public List<Option> getOptions() {
        ArrayList<Option> options = new ArrayList<Option>();
        OptionBuilder.withArgName((String)CMDLINE_OPTION_S);
        OptionBuilder.withLongOpt((String)CMDLINE_OPTION_STOREDIRECTORY);
        OptionBuilder.withDescription((String)"The location of the Neo4j database.");
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_S));
        this.addTaskOptions(options);
        return options;
    }

    protected List<String> getOptionValues(CommandLine options, String option, List<String> defaultValues) {
        if (options.hasOption(option)) {
            ArrayList<String> names = new ArrayList<String>();
            for (String elementName : options.getOptionValues(option)) {
                if (elementName.trim().length() <= 0) continue;
                names.add(elementName);
            }
            return names;
        }
        return defaultValues;
    }

    protected String getOptionValue(CommandLine options, String option, String defaultValue) {
        if (options.hasOption(option)) {
            return options.getOptionValue(option);
        }
        return defaultValue;
    }

    protected void addTaskOptions(List<Option> options) {
    }

    protected Store getStore() {
        File directory = new File(this.storeDirectory);
        LOGGER.info("Opening store in directory '" + directory.getAbsolutePath() + "'");
        if (!directory.exists()) {
            directory.getParentFile().mkdirs();
        }
        return new EmbeddedGraphStore(directory.getAbsolutePath());
    }

    protected abstract void executeTask(Store var1) throws CliExecutionException;
}

