/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.cli;

import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.api.PluginRepository;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.plugin.impl.PluginConfigurationReaderImpl;
import com.buschmais.jqassistant.core.plugin.impl.PluginRepositoryImpl;
import com.buschmais.jqassistant.scm.cli.CliConfigurationException;
import com.buschmais.jqassistant.scm.cli.CliExecutionException;
import com.buschmais.jqassistant.scm.cli.PluginClassLoader;
import com.buschmais.jqassistant.scm.cli.Task;
import com.buschmais.jqassistant.scm.cli.TaskFactory;
import com.buschmais.jqassistant.scm.cli.task.DefaultTaskFactoryImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);
    private static final String ENV_JQASSISTANT_HOME = "JQASSISTANT_HOME";
    private static final String DIRECTORY_PLUGINS = "plugins";
    private final TaskFactory taskFactory;

    public static void main(String[] args) {
        try {
            DefaultTaskFactoryImpl taskFactory = new DefaultTaskFactoryImpl();
            new Main(taskFactory).run(args);
        }
        catch (CliExecutionException e) {
            String message = Main.getErrorMessage(e);
            LOGGER.error(message);
            System.exit(e.getExitCode());
        }
    }

    public Main(TaskFactory taskFactory) {
        this.taskFactory = taskFactory;
    }

    public void run(String[] args) throws CliExecutionException {
        Options options = this.gatherOptions(this.taskFactory);
        CommandLine commandLine = this.getCommandLine(args, options);
        this.interpretCommandLine(commandLine, options, this.taskFactory);
    }

    private static String getErrorMessage(CliExecutionException e) {
        StringBuffer messageBuilder = new StringBuffer();
        Throwable current = e;
        do {
            messageBuilder.append("-> ");
            messageBuilder.append(current.getMessage());
        } while ((current = current.getCause()) != null);
        return messageBuilder.toString();
    }

    private PluginRepository getPluginRepository() throws CliExecutionException {
        PluginConfigurationReaderImpl pluginConfigurationReader = new PluginConfigurationReaderImpl(this.createPluginClassLoader());
        try {
            return new PluginRepositoryImpl((PluginConfigurationReader)pluginConfigurationReader);
        }
        catch (PluginRepositoryException e) {
            throw new CliExecutionException("Cannot create plugin repository.", e);
        }
    }

    private Options gatherOptions(TaskFactory taskFactory) {
        Options options = new Options();
        this.gatherTasksOptions(taskFactory, options);
        this.gatherStandardOptions(options);
        return options;
    }

    private void gatherStandardOptions(Options options) {
        OptionBuilder.withArgName((String)"p");
        OptionBuilder.withDescription((String)"Path to property file; default is jqassistant.properties in the class path");
        OptionBuilder.withLongOpt((String)"properties");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"p"));
        options.addOption(new Option("help", "print this message"));
    }

    private void gatherTasksOptions(TaskFactory taskFactory, Options options) {
        for (Task task : taskFactory.getTasks()) {
            for (Option option : task.getOptions()) {
                options.addOption(option);
            }
        }
    }

    private String gatherTaskNames(TaskFactory taskFactory) {
        StringBuilder builder = new StringBuilder();
        for (String taskName : taskFactory.getTaskNames()) {
            builder.append("'").append(taskName).append("' ");
        }
        return builder.toString().trim();
    }

    private void interpretCommandLine(CommandLine commandLine, Options options, TaskFactory taskFactory) throws CliExecutionException {
        List taskNames = commandLine.getArgList();
        if (taskNames.isEmpty()) {
            this.printUsage(options, "A task must be specified, i.e. one  of " + this.gatherTaskNames(taskFactory));
            System.exit(1);
        }
        PluginRepository pluginRepository = this.getPluginRepository();
        Map<String, Object> properties = this.readProperties(commandLine);
        for (String taskName : taskNames) {
            Task task = taskFactory.fromName(taskName);
            if (task == null) {
                this.printUsage(options, "Unknown task " + taskName);
                System.exit(1);
            }
            this.executeTask(task, options, commandLine, pluginRepository, properties);
        }
    }

    private CommandLine getCommandLine(String[] args, Options options) {
        BasicParser parser = new BasicParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.printUsage(options, e.getMessage());
            System.exit(1);
        }
        return commandLine;
    }

    private void executeTask(Task task, Options option, CommandLine commandLine, PluginRepository pluginRepository, Map<String, Object> properties) throws CliExecutionException {
        try {
            task.withStandardOptions(commandLine);
            task.withOptions(commandLine);
        }
        catch (CliConfigurationException e) {
            this.printUsage(option, e.getMessage());
            System.exit(1);
        }
        task.initialize(pluginRepository, properties);
        task.run();
    }

    private Map<String, Object> readProperties(CommandLine commandLine) throws CliConfigurationException {
        InputStream propertiesStream;
        Properties properties = new Properties();
        if (commandLine.hasOption("p")) {
            File propertyFile = new File(commandLine.getOptionValue("p"));
            if (!propertyFile.exists()) {
                throw new CliConfigurationException("Property file given by command line does not exist: " + propertyFile.getAbsolutePath());
            }
            try {
                propertiesStream = new FileInputStream(propertyFile);
            }
            catch (FileNotFoundException e) {
                throw new CliConfigurationException("Cannot open property file.", e);
            }
        } else {
            propertiesStream = Main.class.getResourceAsStream("/jqassistant.properties");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (propertiesStream != null) {
            try {
                properties.load(propertiesStream);
            }
            catch (IOException e) {
                throw new CliConfigurationException("Cannot load properties from file.", e);
            }
            for (String name : properties.stringPropertyNames()) {
                result.put(name, properties.getProperty(name));
            }
        }
        return result;
    }

    private void printUsage(Options options, String errorMessage) {
        System.out.println(errorMessage);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Main.class.getCanonicalName(), options);
        System.out.println("Example: " + Main.class.getCanonicalName() + " scan -f target/classes,target/test-classes");
    }

    private File getHomeDirectory() {
        String dirName = System.getenv(ENV_JQASSISTANT_HOME);
        if (dirName != null) {
            File dir = new File(dirName);
            if (dir.exists()) {
                LOGGER.debug("Using JQASSISTANT_HOME '" + dir.getAbsolutePath() + "'.");
                return dir;
            }
            LOGGER.warn("JQASSISTANT_HOME '" + dir.getAbsolutePath() + "' points to a non-existing directory.");
            return null;
        }
        LOGGER.warn("JQASSISTANT_HOME is not set.");
        return null;
    }

    private ClassLoader createPluginClassLoader() throws CliExecutionException {
        File pluginDirectory;
        ClassLoader parentClassLoader = Task.class.getClassLoader();
        File homeDirectory = this.getHomeDirectory();
        if (homeDirectory != null && (pluginDirectory = new File(homeDirectory, DIRECTORY_PLUGINS)).exists()) {
            final ArrayList<URL> urls = new ArrayList<URL>();
            Path pluginDirectoryPath = pluginDirectory.toPath();
            SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toFile().getName().endsWith(".jar")) {
                        urls.add(file.toFile().toURI().toURL());
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            try {
                Files.walkFileTree(pluginDirectoryPath, (FileVisitor<? super Path>)visitor);
            }
            catch (IOException e) {
                throw new CliExecutionException("Cannot read plugin directory.", e);
            }
            return new PluginClassLoader(urls, parentClassLoader);
        }
        return parentClassLoader;
    }
}

