/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphml.report.impl;

import com.buschmais.jqassistant.plugin.graphml.report.impl.MetaInformation;
import com.buschmais.xo.api.CompositeObject;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

class SimpleSubGraph {
    private static final String ROLE_GRAPH = "graph";
    private CompositeObject parentNode;
    private Map<Long, SimpleSubGraph> subgraphs = new LinkedHashMap<Long, SimpleSubGraph>(1000);
    private Map<Long, CompositeObject> nodes = new LinkedHashMap<Long, CompositeObject>(1000);
    private Map<Long, CompositeObject> relationships = new LinkedHashMap<Long, CompositeObject>(1000);

    public SimpleSubGraph() {
    }

    public SimpleSubGraph(Map m) {
        if (!SimpleSubGraph.isSubgraph(m)) {
            throw new IllegalArgumentException("the argument m (" + m + ") is not a subgraph map");
        }
        if (m.containsKey("nodes")) {
            this.add(m.get("nodes"));
        }
        if (m.containsKey("relationships")) {
            this.add(m.get("relationships"));
        }
        if (m.containsKey("parent")) {
            this.parentNode = (CompositeObject)m.get("parent");
        }
    }

    public CompositeObject getParentNode() {
        return this.parentNode;
    }

    public Iterable<CompositeObject> getNodes() {
        return this.nodes.values();
    }

    public Collection<CompositeObject> getAllNodes() {
        LinkedHashSet<CompositeObject> allNodes = new LinkedHashSet<CompositeObject>(1000);
        if (this.parentNode != null) {
            allNodes.add(this.parentNode);
        }
        allNodes.addAll(this.nodes.values());
        for (SimpleSubGraph subgraph : this.subgraphs.values()) {
            allNodes.addAll(subgraph.getAllNodes());
        }
        return allNodes;
    }

    public Collection<CompositeObject> getAllRelationships() {
        LinkedHashSet<CompositeObject> allRels = new LinkedHashSet<CompositeObject>(1000);
        allRels.addAll(this.relationships.values());
        for (SimpleSubGraph subgraph : this.subgraphs.values()) {
            allRels.addAll(subgraph.getAllRelationships());
        }
        return allRels;
    }

    public void add(Object value) {
        if (value instanceof CompositeObject) {
            CompositeObject compositeObject = (CompositeObject)value;
            Long id = (Long)compositeObject.getId();
            Object o = compositeObject.getDelegate();
            if (o instanceof Node) {
                this.nodes.put(id, compositeObject);
            } else if (o instanceof Relationship) {
                this.relationships.put(id, compositeObject);
            } else {
                this.add(o);
            }
        } else if (value instanceof SimpleSubGraph) {
            SimpleSubGraph subGraph = (SimpleSubGraph)value;
            this.subgraphs.put(subGraph.getId(), subGraph);
        } else if (value instanceof Relationship) {
            Relationship rel = (Relationship)value;
            this.relationships.put(rel.getId(), new RelationWrapper(rel));
        } else if (value instanceof Node) {
            Node node = (Node)value;
            this.nodes.put(node.getId(), new NodeWrapper(node));
        } else if (value instanceof Iterable) {
            for (Object o : (Iterable)value) {
                this.add(o);
            }
        }
    }

    public static boolean isSubgraph(Map m) {
        return ROLE_GRAPH.equals(m.get("role"));
    }

    public Collection<SimpleSubGraph> getSubgraphs() {
        return this.subgraphs.values();
    }

    public Long getId() {
        return (Long)this.parentNode.getId();
    }

    private class NodeWrapper
    implements CompositeObject {
        private Node node;

        public NodeWrapper(Node node) {
            this.node = node;
        }

        public Long getId() {
            return this.node.getId();
        }

        public <T> T as(Class<T> type) {
            return null;
        }

        public Node getDelegate() {
            return this.node;
        }

        public String toString() {
            return "VirtualNode[labels=" + MetaInformation.getLabelsString(this.node) + "]";
        }
    }

    private class RelationWrapper
    implements CompositeObject {
        private Relationship rel;

        public RelationWrapper(Relationship rel) {
            this.rel = rel;
        }

        public Long getId() {
            return this.rel.getId();
        }

        public <T> T as(Class<T> type) {
            return null;
        }

        public Relationship getDelegate() {
            return this.rel;
        }

        public String toString() {
            return "VirtualRelationship[type=" + this.rel.getType().name() + "]";
        }
    }
}

