/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.helpers.Factory;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.kernel.impl.traversal.TraverserIterator;

public class DefaultTraverser
implements Traverser {
    private final Factory<TraverserIterator> traverserIteratorFactory;
    private TraversalMetadata lastIterator;

    DefaultTraverser(Factory<TraverserIterator> traverserIteratorFactory) {
        this.traverserIteratorFactory = traverserIteratorFactory;
    }

    @Override
    public ResourceIterable<Node> nodes() {
        return new ResourcePathIterableWrapper<Node>((ResourceIterable)this){

            @Override
            protected Node convert(Path path) {
                return path.endNode();
            }
        };
    }

    @Override
    public ResourceIterable<Relationship> relationships() {
        return new ResourcePathIterableWrapper<Relationship>((ResourceIterable)this){

            @Override
            public ResourceIterator<Relationship> iterator() {
                final ResourceIterator<Path> pathIterator = this.pathIterator();
                return new PrefetchingResourceIterator<Relationship>(){

                    @Override
                    public void close() {
                        pathIterator.close();
                    }

                    @Override
                    protected Relationship fetchNextOrNull() {
                        while (pathIterator.hasNext()) {
                            Path path = (Path)pathIterator.next();
                            if (path.length() <= 0) continue;
                            return path.lastRelationship();
                        }
                        return null;
                    }
                };
            }

            @Override
            protected Relationship convert(Path path) {
                return path.lastRelationship();
            }
        };
    }

    @Override
    public ResourceIterator<Path> iterator() {
        TraverserIterator traverserIterator = (TraverserIterator)this.traverserIteratorFactory.newInstance();
        this.lastIterator = traverserIterator;
        return traverserIterator;
    }

    @Override
    public TraversalMetadata metadata() {
        return this.lastIterator;
    }

    private static abstract class ResourcePathIterableWrapper<T>
    implements ResourceIterable<T> {
        private final ResourceIterable<Path> iterableToWrap;

        protected ResourcePathIterableWrapper(ResourceIterable<Path> iterableToWrap) {
            this.iterableToWrap = iterableToWrap;
        }

        protected ResourceIterator<Path> pathIterator() {
            return this.iterableToWrap.iterator();
        }

        @Override
        public ResourceIterator<T> iterator() {
            final ResourceIterator<Path> iterator = this.pathIterator();
            return new PrefetchingResourceIterator<T>(){

                @Override
                public void close() {
                    iterator.close();
                }

                @Override
                protected T fetchNextOrNull() {
                    return iterator.hasNext() ? (Object)ResourcePathIterableWrapper.this.convert((Path)iterator.next()) : null;
                }
            };
        }

        protected abstract T convert(Path var1);
    }
}

